/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.editor;

import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class PythonTypedTextInterceptor
implements TypedTextInterceptor {
    private int caretPosition = -1;

    public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        String txt = context.getText();
        if (context.getReplacedText().length() == 0) {
            switch (txt) {
                case "{": {
                    context.setText("{}", 1);
                    break;
                }
                case "}": {
                    if (!"}".equals(PythonTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) break;
                    this.skipNext(context);
                    break;
                }
                case "[": {
                    context.setText("[]", 1);
                    break;
                }
                case "]": {
                    if (!"]".equals(PythonTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) break;
                    this.skipNext(context);
                    break;
                }
                case "(": {
                    context.setText("()", 1);
                    break;
                }
                case ")": {
                    if (!")".equals(PythonTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) break;
                    this.skipNext(context);
                    break;
                }
                case " ": {
                    String b = PythonTypedTextInterceptor.textBefore((TypedTextInterceptor.Context)context, 1);
                    String a = PythonTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1);
                    if ((!"{".equals(b) || !"}".equals(a)) && (!"[".equals(b) || !"]".equals(a))) break;
                    context.setText("  ", 1);
                    break;
                }
                case "\"": {
                    if ("\"".equals(PythonTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) {
                        this.skipNext(context);
                        break;
                    }
                    int quotes = PythonTypedTextInterceptor.quotesInLine((TypedTextInterceptor.Context)context, '\"');
                    if (quotes % 2 != 0) break;
                    context.setText("\"\"", 1);
                    break;
                }
                case "'": {
                    if ("'".equals(PythonTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) {
                        this.skipNext(context);
                        break;
                    }
                    int quotes = PythonTypedTextInterceptor.quotesInLine((TypedTextInterceptor.Context)context, '\'');
                    if (quotes % 2 != 0) break;
                    context.setText("''", 1);
                }
            }
        }
    }

    private void skipNext(TypedTextInterceptor.MutableContext context) {
        context.setText("", 0);
        this.caretPosition = context.getOffset() + 1;
    }

    private static String textAfter(TypedTextInterceptor.Context context, int length) throws BadLocationException {
        int next = Math.min(length, context.getDocument().getLength() - context.getOffset());
        return context.getDocument().getText(context.getOffset(), next);
    }

    private static String textBefore(TypedTextInterceptor.Context context, int lenght) throws BadLocationException {
        int pre = Math.min(lenght, context.getOffset());
        return context.getDocument().getText(context.getOffset() - pre, pre);
    }

    private static int quotesInLine(TypedTextInterceptor.Context context, char quote) throws BadLocationException {
        LineDocument doc = (LineDocument)context.getDocument();
        int lineStart = LineDocumentUtils.getLineStart((LineDocument)doc, (int)context.getOffset());
        int lineEnd = LineDocumentUtils.getLineEnd((LineDocument)doc, (int)context.getOffset());
        char[] line = doc.getText(lineStart, lineEnd - lineStart).toCharArray();
        int quotes = 0;
        for (int i = 0; i < line.length; ++i) {
            char d = line[i];
            if ('\\' == d) {
                ++i;
                continue;
            }
            if (quote != d) continue;
            ++quotes;
        }
        return quotes;
    }

    public void afterInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        if (this.caretPosition > -1) {
            context.getComponent().setCaretPosition(this.caretPosition);
            this.caretPosition = -1;
        }
    }

    public void cancelled(TypedTextInterceptor.Context context) {
    }
}

