/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.indexing;

import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.Action;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.parsing.impl.indexing.errors.Utilities;
import org.netbeans.modules.parsing.impl.indexing.implspi.FileAnnotationsRefresh;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.netbeans.modules.python.indexing.PythonIndexQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PythonErrorAnnotator
extends AnnotationProvider
implements FileAnnotationsRefresh {
    private static final Logger LOG = Logger.getLogger(PythonErrorAnnotator.class.getName());
    private static final String ERROR_BADGE_URL = "org/netbeans/modules/python/error-badge.png";
    final String PACKAGE_BADGE = ((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/python/package.png").toExternalForm();
    private static final String IMAGE = "org/netbeans/modules/python/package.png";

    public String annotateName(String name, Set files) {
        return null;
    }

    public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
        boolean singleFile;
        FileObject fo = files.iterator().next();
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (!Utilities.isBadgesEnabled() || owner == null || !owner.getClass().getName().equals("org.netbeans.modules.python.project.PythonProject")) {
            return null;
        }
        boolean inError = false;
        boolean bl = singleFile = files.size() == 1;
        if (files instanceof NonRecursiveFolder) {
            FileObject folder = ((NonRecursiveFolder)files).getFolder();
            inError = this.isInError(folder, false, true);
            singleFile = false;
        } else {
            for (Object e : files) {
                if (!(e instanceof FileObject)) continue;
                FileObject f = (FileObject)e;
                if (f.isFolder()) {
                    singleFile = false;
                    if (this.isInError(f, true, !inError)) {
                        inError = true;
                        continue;
                    }
                    if (!inError) continue;
                    continue;
                }
                if (!f.isData() || !this.isInError(f, true, !inError)) continue;
                inError = true;
            }
        }
        if (Logger.getLogger(PythonErrorAnnotator.class.getName()).isLoggable(Level.FINE)) {
            Logger.getLogger(PythonErrorAnnotator.class.getName()).log(Level.FINE, "files={0}, in error={1}", new Object[]{files, inError});
        }
        if (owner.getClass().getName().equals("org.netbeans.modules.python.project.PythonProject") && files.size() == 1 && fo.isFolder() && fo.getFileObject("__init__.py") != null) {
            icon = ImageUtilities.mergeImages((Image)icon, (Image)ImageUtilities.addToolTipToImage((Image)ImageUtilities.loadImage((String)IMAGE), (String)("<img src='" + this.PACKAGE_BADGE + "' width='8' height='8'>&nbsp;Python Package")), (int)7, (int)7);
        }
        if (inError) {
            URL errorBadgeIconURL = PythonErrorAnnotator.class.getResource("/org/netbeans/modules/python/error-badge.png");
            assert (errorBadgeIconURL != null);
            String string = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(PythonErrorAnnotator.class, (String)"TP_ErrorBadgeSingle");
            Image errorBadge = ImageUtilities.loadImage((String)ERROR_BADGE_URL);
            assert (errorBadge != null);
            String errorBadgeFolderTP = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(PythonErrorAnnotator.class, (String)"TP_ErrorBadgeFolder");
            Image i = ImageUtilities.mergeImages((Image)icon, (Image)(singleFile ? ImageUtilities.assignToolTipToImage((Image)errorBadge, (String)string) : ImageUtilities.assignToolTipToImage((Image)errorBadge, (String)errorBadgeFolderTP)), (int)0, (int)8);
            Iterator it = Lookup.getDefault().lookupAll(AnnotationProvider.class).iterator();
            boolean found = false;
            while (it.hasNext()) {
                AnnotationProvider p = (AnnotationProvider)it.next();
                if (found) {
                    Image res = p.annotateIcon(i, iconType, files);
                    if (res == null) continue;
                    return res;
                }
                found = p == this;
            }
            return i;
        }
        return icon;
    }

    public String annotateNameHtml(String name, Set files) {
        return null;
    }

    public Action[] actions(Set files) {
        return null;
    }

    public InterceptionListener getInterceptionListener() {
        return null;
    }

    private synchronized boolean isInError(FileObject file, boolean recursive, boolean forceValue) {
        boolean result = false;
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (owner == null) {
            return result;
        }
        URL toURL = owner.getProjectDirectory().toURL();
        PythonIndexQuery.queryPerFile(toURL, file, "has_errors");
        try {
            Collection allFilesInError = ErrorsCache.getAllFilesInError((URL)toURL);
            Stream<URL> filter = allFilesInError.stream().filter(url -> url.toString() != null && StringUtils.startsWith((CharSequence)url.toString(), (CharSequence)file.toURL().toString()));
            if (filter.count() > 0L) {
                result = true;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public void refresh(Set<URL> set) {
        try {
            HashSet toRefresh = new HashSet();
            set.forEach(t -> toRefresh.add(URLMapper.findFileObject((URL)t)));
            if (toRefresh.iterator().hasNext()) {
                FileObject next = (FileObject)toRefresh.iterator().next();
                if (next == null) {
                    return;
                }
                this.fireFileStatusChanged(new FileStatusEvent(next.getFileSystem(), toRefresh, true, false));
            }
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

