/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.options;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.IOUtils;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.python.Installer;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.options.PythonLspServerConfigsOptionsPanelController;
import org.netbeans.modules.python.options.PythonPackagesListRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;

final class PythonLspServerConfigsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static String[] PACKAGES = new String[]{"pylsp", "pyls-isort", "pylsp-mypy", "pylsp-rope", "black", "python-lsp-black", "isort", "pyls-memestra", "ptpython", "ipython", "pytest", "pynguin", "build", "pdoc", "poetry"};
    private final PythonLspServerConfigsOptionsPanelController controller;
    static final File settingsSchema = PythonUtility.SETTINGS_SCHEMA;
    static final JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
    static Set<ValidationMessage> errors;
    private JLabel errroLabel;
    private JEditorPane lspEditorPane;
    private JList lspList;
    private JPanel lspPanel;
    private JLabel lspPythonVersionLabel;
    private JScrollPane lspScrollPane;
    private JCheckBox lspServerCheckBox;
    private JLabel lspServerLabel;
    private JPanel lspSettingsPanel;
    private JScrollPane lspSettingsScrollPane;
    private JSplitPane lspSplitPane;

    PythonLspServerConfigsPanel(final PythonLspServerConfigsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.lspList.setCellRenderer(new PythonPackagesListRenderer());
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                controller.changed();
            }
        };
        this.lspEditorPane.getDocument().addDocumentListener(dl);
    }

    private void initComponents() {
        this.lspSplitPane = new JSplitPane();
        this.lspPanel = new JPanel();
        this.lspServerCheckBox = new JCheckBox();
        this.lspServerLabel = new JLabel();
        this.lspScrollPane = new JScrollPane();
        this.lspList = new JList();
        this.lspPythonVersionLabel = new JLabel();
        this.lspSettingsPanel = new JPanel();
        this.lspSettingsScrollPane = new JScrollPane();
        this.lspEditorPane = new JEditorPane();
        this.errroLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.lspSplitPane.setDividerSize(1);
        this.lspSplitPane.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.lspServerCheckBox, (String)NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.lspServerCheckBox.text"));
        this.lspServerCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PythonLspServerConfigsPanel.this.lspServerCheckBoxStateChanged(evt);
            }
        });
        this.lspServerLabel.setFont(new Font("Segoe UI", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.lspServerLabel, (String)NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.lspServerLabel.text"));
        this.lspList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PythonLspServerConfigsPanel.this.lspListMouseClicked(evt);
            }
        });
        this.lspScrollPane.setViewportView(this.lspList);
        this.lspPythonVersionLabel.setFont(new Font("Segoe UI", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.lspPythonVersionLabel, (String)NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.lspPythonVersionLabel.text"));
        GroupLayout lspPanelLayout = new GroupLayout(this.lspPanel);
        this.lspPanel.setLayout(lspPanelLayout);
        lspPanelLayout.setHorizontalGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspPanelLayout.createSequentialGroup().addContainerGap().addGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lspPythonVersionLabel, -1, 245, Short.MAX_VALUE).addComponent(this.lspServerLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspPanelLayout.createSequentialGroup().addContainerGap().addGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lspServerCheckBox).addComponent(this.lspScrollPane, -2, 0, Short.MAX_VALUE)).addContainerGap())));
        lspPanelLayout.setVerticalGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspPanelLayout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.lspPythonVersionLabel, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lspServerLabel, -2, 18, -2).addContainerGap()).addGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lspServerCheckBox).addGap(56, 56, 56).addComponent(this.lspScrollPane, -1, 309, Short.MAX_VALUE).addGap(30, 30, 30))));
        this.lspSplitPane.setLeftComponent(this.lspPanel);
        this.lspSettingsScrollPane.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.lspSettingsScrollPane.border.title")));
        this.lspSettingsScrollPane.setPreferredSize(new Dimension(10, 942));
        this.lspSettingsScrollPane.setRowHeaderView(null);
        this.lspSettingsScrollPane.setViewportView(null);
        this.lspEditorPane.setContentType("text/x-json");
        this.lspSettingsScrollPane.setViewportView(this.lspEditorPane);
        this.errroLabel.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.errroLabel, (String)NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.errroLabel.text"));
        GroupLayout lspSettingsPanelLayout = new GroupLayout(this.lspSettingsPanel);
        this.lspSettingsPanel.setLayout(lspSettingsPanelLayout);
        lspSettingsPanelLayout.setHorizontalGroup(lspSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.errroLabel, -1, 357, Short.MAX_VALUE).addContainerGap()).addGroup(lspSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lspSettingsScrollPane, -1, 357, Short.MAX_VALUE).addContainerGap())));
        lspSettingsPanelLayout.setVerticalGroup(lspSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, lspSettingsPanelLayout.createSequentialGroup().addContainerGap(418, Short.MAX_VALUE).addComponent(this.errroLabel).addContainerGap()).addGroup(lspSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lspSettingsScrollPane, -1, 390, Short.MAX_VALUE).addGap(28, 28, 28))));
        this.lspSplitPane.setRightComponent(this.lspSettingsPanel);
        this.add((Component)this.lspSplitPane, "Center");
    }

    private void lspServerCheckBoxStateChanged(ChangeEvent evt) {
        this.controller.changed();
    }

    private void lspListMouseClicked(MouseEvent evt) {
        Pair selected;
        if (SwingUtilities.isRightMouseButton(evt) && !((Boolean)(selected = (Pair)this.lspList.getSelectedValue()).second()).booleanValue()) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem pm = new JMenuItem("Install");
            pm.addActionListener(e -> {
                String[] cmd = new String[]{PythonUtility.getLspPythonExe(), "-m", "pip", "install", "--upgrade", (String)selected.first()};
                PythonUtility.processExecutor(cmd, String.format("%s %s", "Installing", selected.first()));
            });
            menu.add(pm);
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    void load() {
        if (errors != null && !errors.isEmpty()) {
            return;
        }
        try {
            this.lspServerCheckBox.setSelected(NbPreferences.root().getBoolean("autoUpdate", false));
            this.lspServerLabel.setText(String.format("%s%s", "Current Version: ", PythonUtility.getServerVersion()));
            this.lspPythonVersionLabel.setText(String.format("%s%s", "Python Version: ", PythonUtility.getVersion(PythonUtility.getLspPythonExe())));
            String pipListOutput = PythonUtility.getPipList(PythonUtility.getLspPythonExe());
            DefaultListModel<Pair> model = new DefaultListModel<Pair>();
            for (String pipPackage : PACKAGES) {
                if (pipListOutput.contains(pipPackage)) {
                    model.addElement(Pair.of((Object)pipPackage, (Object)true));
                    continue;
                }
                model.addElement(Pair.of((Object)pipPackage, (Object)false));
            }
            this.lspList.setModel(model);
            this.lspEditorPane.setText(Files.readString(PythonUtility.SETTINGS.toPath()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void store() {
        if (this.controller.isChanged()) {
            this.errroLabel.setText("");
            try {
                JsonNode jsonNode;
                JsonSchema jsonSchema;
                String jsonSettings = this.lspEditorPane.getText();
                NbPreferences.root().putBoolean("autoUpdate", this.lspServerCheckBox.isSelected());
                if (!settingsSchema.exists()) {
                    Files.writeString(settingsSchema.toPath(), (CharSequence)IOUtils.resourceToString((String)"org/netbeans/modules/python/schema.json", (Charset)StandardCharsets.UTF_8, (ClassLoader)Installer.class.getClassLoader()), new OpenOption[0]);
                }
                if (!(errors = (jsonSchema = factory.getSchema(Files.readString(settingsSchema.toPath()))).validate(jsonNode = new ObjectMapper().readTree(jsonSettings))).isEmpty()) {
                    this.errroLabel.setText(errors.iterator().next().getMessage());
                    return;
                }
                Files.writeString(PythonUtility.SETTINGS.toPath(), (CharSequence)jsonSettings, new OpenOption[0]);
                Gson create = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.BIG_DECIMAL).create();
                Map settings = (Map)create.fromJson(jsonSettings, new TypeToken<HashMap<String, Object>>(){}.getType());
                if (settings != null) {
                    HashMap<String, Map> paramsObject = new HashMap<String, Map>();
                    NbPreferences.root().putBoolean("auto_pop_completion", settings.getOrDefault("auto_pop_completion", true));
                    settings.remove("auto_pop_completion");
                    paramsObject.put("pylsp", settings);
                    DidChangeConfigurationParams params = new DidChangeConfigurationParams(paramsObject);
                    LSPBindings.getAllBindings().forEach(server -> server.getWorkspaceService().didChangeConfiguration(params));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    boolean valid() {
        return true;
    }
}

