/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.options;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.javatuples.Quartet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netbeans.modules.python.PythonUtility;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public class PythonPlatformManager {
    public static File getPathFile() {
        return PythonUtility.ENVS;
    }

    private static File getPlatformFile() {
        return PythonUtility.PLATFORMS;
    }

    public static List<Quartet<String, String, String, Boolean>> getPythonExes() {
        ArrayList<Quartet<String, String, String, Boolean>> exes = new ArrayList<Quartet<String, String, String, Boolean>>();
        try {
            JSONArray platformJsonArray = new JSONArray(Files.readString(PythonPlatformManager.getPlatformFile().toPath()));
            for (int i = 0; i < platformJsonArray.length(); ++i) {
                JSONObject jsonObject = platformJsonArray.getJSONObject(i);
                exes.add((Quartet<String, String, String, Boolean>)Quartet.with((Object)(jsonObject.has("name") ? jsonObject.getString("name") : jsonObject.getString("version")), (Object)jsonObject.getString("cmd"), (Object)jsonObject.getString("version"), (Object)jsonObject.getBoolean("state")));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return exes;
    }

    public static String getPythonPath() {
        try {
            JSONArray pathsJsonArray = new JSONArray(Files.readString(PythonPlatformManager.getPathFile().toPath()));
            for (int i = 0; i < pathsJsonArray.length(); ++i) {
                JSONObject jsonObject = pathsJsonArray.getJSONObject(i);
                if (!jsonObject.has("pythonpath")) continue;
                return jsonObject.getString("pythonpath");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return "";
    }

    public static void refresh() {
        try {
            List<Pair<String, String>> pythonExes = PythonUtility.getPythonExes();
            JSONArray platformJsonArray = new JSONArray(Files.readString(PythonPlatformManager.getPlatformFile().toPath()));
            for (Pair<String, String> pythonExe : pythonExes) {
                if (!platformJsonArray.toString().contains(StringEscapeUtils.escapeJava((String)((String)pythonExe.second())))) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("cmd", (String)pythonExe.second());
                    hashMap.put("version", (String)pythonExe.first());
                    hashMap.put("name", (String)pythonExe.first());
                    hashMap.put("state", "false");
                    platformJsonArray.put((Object)new JSONObject(hashMap));
                }
                PythonPlatformManager.savePlaltformJson(platformJsonArray);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void savePlaltformJson(JSONArray array) {
        try {
            Files.writeString(PythonPlatformManager.getPlatformFile().toPath(), (CharSequence)array.toString(), new OpenOption[0]);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static void delete(String value0) {
        try {
            JSONArray platformJsonArray = new JSONArray(Files.readString(PythonPlatformManager.getPlatformFile().toPath()));
            for (int i = 0; i < platformJsonArray.length(); ++i) {
                JSONObject jsonObject = platformJsonArray.getJSONObject(i);
                if (!jsonObject.getString("cmd").equals(value0)) continue;
                platformJsonArray.remove(i);
            }
            PythonPlatformManager.savePlaltformJson(platformJsonArray);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static void setSelected(String value1, String state) {
        try {
            JSONArray platformJsonArray = new JSONArray(Files.readString(PythonPlatformManager.getPlatformFile().toPath()));
            for (int i = 0; i < platformJsonArray.length(); ++i) {
                JSONObject jsonObject = platformJsonArray.getJSONObject(i);
                if (Boolean.parseBoolean(jsonObject.getString("state"))) {
                    jsonObject.put("state", (Object)"false");
                }
                if (!jsonObject.getString("cmd").equals(value1)) continue;
                jsonObject.put("state", (Object)state);
            }
            PythonPlatformManager.savePlaltformJson(platformJsonArray);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static void insert(String cmd) {
        try {
            JSONArray platformJsonArray = new JSONArray(Files.readString(PythonPlatformManager.getPlatformFile().toPath()));
            if (!platformJsonArray.toString().contains(StringEscapeUtils.escapeJava((String)cmd))) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("cmd", cmd);
                hashMap.put("name", PythonUtility.getVersion(cmd));
                hashMap.put("version", PythonUtility.getVersion(cmd));
                hashMap.put("state", "false");
                platformJsonArray.put((Object)new JSONObject(hashMap));
            }
            PythonPlatformManager.savePlaltformJson(platformJsonArray);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static String getDefault() throws IOException {
        try {
            JSONArray platformJsonArray = new JSONArray(Files.readString(PythonPlatformManager.getPlatformFile().toPath()));
            for (int i = 0; i < platformJsonArray.length(); ++i) {
                JSONObject jsonObject = platformJsonArray.getJSONObject(i);
                if (!Boolean.parseBoolean(jsonObject.getString("state"))) continue;
                return jsonObject.getString("cmd");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        List<Pair<String, String>> pythonExes = PythonUtility.getPythonExes();
        return !pythonExes.isEmpty() ? (String)pythonExes.get(0).second() : "";
    }

    public static void setName(String value1, String text) {
        try {
            JSONArray platformJsonArray = new JSONArray(Files.readString(PythonPlatformManager.getPlatformFile().toPath()));
            for (int i = 0; i < platformJsonArray.length(); ++i) {
                JSONObject jsonObject = platformJsonArray.getJSONObject(i);
                if (!jsonObject.getString("cmd").equals(value1)) continue;
                jsonObject.put("name", (Object)text);
            }
            PythonPlatformManager.savePlaltformJson(platformJsonArray);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

