/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.packagemanager;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.javatuples.Triplet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.packagemanager.PythonRootTreeNode;
import org.netbeans.modules.python.packagemanager.PythonRowModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RowModel;
import org.openide.util.Exceptions;

public class PythonPackagesModel {
    static HashMap<String, String> installedMap;
    static String[] userRepos;
    static TreeModel model;
    static DefaultMutableTreeNode installedPackages;

    public static OutlineModel getModel() {
        PythonRootTreeNode root = new PythonRootTreeNode(Triplet.with((Object)"Packages", (Object)"", (Object)""));
        installedPackages = new DefaultMutableTreeNode(Triplet.with((Object)"Installed", (Object)"", (Object)""));
        PythonRootTreeNode pyPi = new PythonRootTreeNode(Triplet.with((Object)"PyPI", (Object)"", (Object)""));
        root.add(installedPackages);
        root.add(pyPi);
        installedPackages.add(PythonPackagesModel.addLoadingNode());
        pyPi.add(PythonPackagesModel.addLoadingNode());
        PythonPackagesModel.addUserRepos(root);
        JTree tree = new JTree(root);
        model = tree.getModel();
        OutlineModel mdl = DefaultOutlineModel.createOutlineModel((TreeModel)model, (RowModel)new PythonRowModel(), (boolean)true, (String)"Package");
        return mdl;
    }

    private static DefaultMutableTreeNode addLoadingNode() {
        return new DefaultMutableTreeNode(Triplet.with((Object)"Loading", (Object)"", (Object)""), false);
    }

    public static void loadInstalled(final String pythonPath) throws JSONException {
        final ProgressHandle createHandle = ProgressHandle.createHandle((String)"Collecting installed Packages");
        createHandle.setInitialDelay(0);
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                JSONArray installedPackages1 = this.getInstalledPackages(pythonPath);
                createHandle.start(installedPackages1.length());
                installedPackages.removeAllChildren();
                installedMap = new HashMap(installedPackages1.length());
                for (int i = 0; i < installedPackages1.length(); ++i) {
                    JSONObject ipackage = installedPackages1.getJSONObject(i);
                    String name = ipackage.getString("name");
                    String version = ipackage.getString("version");
                    createHandle.progress(name + ":" + version, i);
                    installedMap.putIfAbsent(name, version);
                    installedPackages.add(new DefaultMutableTreeNode(Triplet.with((Object)name, (Object)version, (Object)"")));
                }
                return null;
            }

            @Override
            protected void done() {
                PythonPackagesModel.refresh(installedPackages);
                createHandle.finish();
            }

            private JSONArray getInstalledPackages(String pythonPath2) {
                try {
                    return new JSONArray(PythonUtility.getCommandOutput(new String[]{pythonPath2, "-m", "pip", "list", "--format", "json"}, null));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return new JSONArray();
                }
            }
        }.execute();
    }

    public static void loadPyPI(final DefaultMutableTreeNode pyPi) {
        final ProgressHandle createHandle = ProgressHandle.createHandle((String)"Collecting PyPI indexe");
        createHandle.setInitialDelay(0);
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Elements pypiPackages = this.getPypiPackages();
                createHandle.start(pypiPackages.size());
                pyPi.removeAllChildren();
                int count = 0;
                for (Element pypiPackage : pypiPackages) {
                    String text = pypiPackage.text();
                    createHandle.progress(text, ++count);
                    pyPi.add(new DefaultMutableTreeNode(Triplet.with((Object)text, (Object)installedMap.getOrDefault(text, ""), (Object)"https://pypi.org/project")));
                }
                return null;
            }

            @Override
            protected void done() {
                PythonPackagesModel.refresh(pyPi);
                createHandle.finish();
            }

            private Elements getPypiPackages() {
                HttpResponse response = Unirest.get((String)"https://pypi.org/simple").asString();
                Document parse = Jsoup.parse((String)((String)response.getBody()), (Parser)Parser.htmlParser());
                Elements select = parse.select("body > a");
                return select;
            }
        }.execute();
    }

    static void collapse(final DefaultMutableTreeNode node) {
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                node.removeAllChildren();
                node.add(PythonPackagesModel.addLoadingNode());
                return null;
            }

            @Override
            protected void done() {
                PythonPackagesModel.refresh(node);
            }
        }.execute();
    }

    private static void refresh(DefaultMutableTreeNode node) {
        ((DefaultTreeModel)model).nodeStructureChanged(node);
    }

    private static void addUserRepos(DefaultMutableTreeNode root) {
        try {
            File file = PythonUtility.REPOS;
            if (!file.exists()) {
                return;
            }
            JSONArray jsonArray = new JSONArray(Files.readString(file.toPath()));
            DefaultListModel listModel = new DefaultListModel();
            userRepos = new String[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                String login;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String name = jsonObject.getString("name");
                String url = jsonObject.getString("url");
                char[] pass = Keyring.read((String)(login = jsonObject.getString("login")));
                PythonRootTreeNode defaultMutableTreeNode = new PythonRootTreeNode(Triplet.with((Object)name, (Object)(login + "@" + (Serializable)(pass != null ? pass : (char[])"")), (Object)url));
                defaultMutableTreeNode.add(PythonPackagesModel.addLoadingNode());
                root.add(defaultMutableTreeNode);
                PythonPackagesModel.userRepos[i] = name;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static void loadUserRepos(final DefaultMutableTreeNode node) {
        Triplet triplet = (Triplet)node.getUserObject();
        final String url = triplet.getValue2().toString().strip();
        String[] cred = triplet.getValue1().toString().split("@");
        final String login = cred[0];
        final String pass = cred[1];
        final ProgressHandle createHandle = ProgressHandle.createHandle((String)("Collecting " + triplet.getValue0().toString() + " indexe"));
        createHandle.setInitialDelay(0);
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Elements repoPackages = this.getRepoPackages();
                createHandle.start(repoPackages.size());
                node.removeAllChildren();
                int count = 0;
                for (Element repoPackage : repoPackages) {
                    String text = repoPackage.text();
                    createHandle.progress(text, ++count);
                    node.add(new DefaultMutableTreeNode(Triplet.with((Object)text, (Object)installedMap.getOrDefault(text, ""), (Object)url)));
                }
                return null;
            }

            @Override
            protected void done() {
                PythonPackagesModel.refresh(node);
                createHandle.finish();
            }

            private Elements getRepoPackages() {
                HttpResponse response = ((GetRequest)Unirest.get((String)url).basicAuth(login, pass)).asString();
                Document parse = Jsoup.parse((String)((String)response.getBody()), (Parser)Parser.htmlParser());
                Elements select = parse.select("body > a");
                return select;
            }
        }.execute();
    }
}

