/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.poetry;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.poetry.Bundle;
import org.netbeans.modules.python.poetry.PythonPoetryInit;
import org.netbeans.modules.python.poetry.PythonPoetryInstall;
import org.netbeans.modules.python.poetry.PythonPoetryRunScript;
import org.netbeans.modules.python.poetry.PythonPoetryShell;
import org.netbeans.modules.python.poetry.PythonPoetryShow;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public class PythonPoetryMenuAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    PythonProject p;
    Map poetryScripts;
    DataObject dataObject;

    public PythonPoetryMenuAction(PythonProject p, boolean b, Map poetryScripts) {
        this.putValue("hideWhenDisabled", true);
        this.setEnabled(b);
        this.p = p;
        this.poetryScripts = poetryScripts;
    }

    public PythonPoetryMenuAction() {
        this.putValue("hideWhenDisabled", true);
        this.setEnabled(false);
    }

    private PythonPoetryMenuAction(DataObject dataObject, boolean b) {
        this.putValue("hideWhenDisabled", true);
        this.setEnabled(b);
        this.dataObject = dataObject;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup ctx) {
        PythonProject project = (PythonProject)ctx.lookup(PythonProject.class);
        if (project == null) {
            DataObject dataObj = (DataObject)ctx.lookup(DataObject.class);
            if (dataObj != null && dataObj.getPrimaryFile().isFolder() && FileOwnerQuery.getOwner((FileObject)dataObj.getPrimaryFile()) == null) {
                return new PythonPoetryMenuAction(dataObj, true);
            }
            return this;
        }
        if (PythonUtility.isPoetry(project)) {
            Map poetryScr = null;
            try (FileConfig conf = FileConfig.of((File)FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("pyproject.toml")));){
                conf.load();
                Config poetryScriptsConf = (Config)conf.get("tool.poetry.scripts");
                if (poetryScriptsConf != null) {
                    poetryScr = poetryScriptsConf.valueMap();
                }
            }
            return new PythonPoetryMenuAction(project, true, poetryScr);
        }
        return this;
    }

    public JMenuItem getPopupPresenter() {
        JMenu main = new JMenu(Bundle.CTL_PythonPoetryMenuAction());
        JMenu scriptsMenu = new JMenu(Bundle.CTL_PythonPoetryRunScriptsMenu());
        if (this.p != null) {
            main.add(new PythonPoetryInstall(this.p));
            if (this.poetryScripts != null) {
                this.poetryScripts.forEach((t, u) -> scriptsMenu.add(new PythonPoetryRunScript(this.p, t.toString())));
                main.add(scriptsMenu);
            }
            main.add(new PythonPoetryShow(this.p));
            main.add(new PythonPoetryShell(this.p));
        } else {
            main.add(new PythonPoetryInit(this.dataObject));
        }
        return this.isEnabled() ? main : null;
    }
}

