/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.projectproperties;

import java.awt.Font;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.modules.python.project.PythonProjectStateHandler;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PythonBuildPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    PythonProject project;
    private JLabel buildParamsLabel;
    public static JTextField buildParamsTextField;

    public PythonBuildPanel(PythonProject project) {
        this.initComponents();
        this.project = project;
        buildParamsTextField.getDocument().addDocumentListener(this);
        this.loadProperties();
    }

    private void initComponents() {
        this.buildParamsLabel = new JLabel();
        buildParamsTextField = new JTextField();
        this.setBorder(BorderFactory.createTitledBorder(null, NbBundle.getMessage(PythonBuildPanel.class, (String)"PythonBuildPanel.border.title"), 0, 0, new Font("Segoe UI", 1, 12)));
        Mnemonics.setLocalizedText((JLabel)this.buildParamsLabel, (String)NbBundle.getMessage(PythonBuildPanel.class, (String)"PythonBuildPanel.buildParamsLabel.text"));
        buildParamsTextField.setText(NbBundle.getMessage(PythonBuildPanel.class, (String)"PythonBuildPanel.buildParamsTextField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.buildParamsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(buildParamsTextField).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildParamsLabel).addComponent(buildParamsTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void loadProperties() {
        try {
            Properties prop = PythonUtility.getProperties(this.project, false);
            buildParamsTextField.setText(prop.getProperty("nbproject.build.params", ""));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void setProperties(PythonProject project) {
        try {
            Properties prop = PythonUtility.getProperties(project, false);
            prop.setProperty("nbproject.build.params", buildParamsTextField.getText());
            prop.store(new FileWriter(FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"))), null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void markChange() {
        ((PythonProjectStateHandler)this.project.getLookup().lookup(PythonProjectStateHandler.class)).mark();
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.markChange();
    }
}

