/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.projectproperties;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.javatuples.Quartet;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.options.PythonPlatformManager;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.modules.python.project.PythonProjectStateHandler;
import org.netbeans.modules.python.projectproperties.PythonPlatformCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class PythonGeneralPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    PythonProject project;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private static JTextArea descriptionTextArea;
    private JLabel projectNameLabel;
    private static JTextField projectNameTextField;
    private static JComboBox<Pair> pythonComboBox;
    private JLabel pythonLabel;
    private JLabel versionLabel;
    private static JTextField versionTextField;

    public PythonGeneralPanel(PythonProject project) {
        this.initComponents();
        this.project = project;
        pythonComboBox.setRenderer(new PythonPlatformCellRenderer());
        projectNameTextField.getDocument().addDocumentListener(this);
        versionTextField.getDocument().addDocumentListener(this);
        descriptionTextArea.getDocument().addDocumentListener(this);
        this.loadProperties();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.pythonLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        projectNameTextField = new JTextField();
        versionTextField = new JTextField();
        pythonComboBox = new JComboBox();
        this.descriptionScrollPane = new JScrollPane();
        descriptionTextArea = new JTextArea();
        this.setBorder(BorderFactory.createTitledBorder(null, NbBundle.getMessage(PythonGeneralPanel.class, (String)"PythonGeneralPanel.border.title"), 0, 0, new Font("Segoe UI", 1, 12)));
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PythonGeneralPanel.class, (String)"PythonGeneralPanel.projectNameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(PythonGeneralPanel.class, (String)"PythonGeneralPanel.versionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.pythonLabel, (String)NbBundle.getMessage(PythonGeneralPanel.class, (String)"PythonGeneralPanel.pythonLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(PythonGeneralPanel.class, (String)"PythonGeneralPanel.descriptionLabel.text"));
        projectNameTextField.setText(NbBundle.getMessage(PythonGeneralPanel.class, (String)"PythonGeneralPanel.projectNameTextField.text"));
        versionTextField.setText(NbBundle.getMessage(PythonGeneralPanel.class, (String)"PythonGeneralPanel.versionTextField.text"));
        pythonComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonGeneralPanel.this.pythonComboBoxActionPerformed(evt);
            }
        });
        descriptionTextArea.setColumns(20);
        descriptionTextArea.setRows(3);
        this.descriptionScrollPane.setViewportView(descriptionTextArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameLabel).addComponent(this.versionLabel).addComponent(this.pythonLabel).addComponent(this.descriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(projectNameTextField).addComponent(this.descriptionScrollPane, -1, 217, Short.MAX_VALUE).addComponent(pythonComboBox, 0, -1, Short.MAX_VALUE).addComponent(versionTextField)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameLabel).addComponent(projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(versionTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pythonLabel).addComponent(pythonComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel).addComponent(this.descriptionScrollPane, -1, 31, Short.MAX_VALUE)).addContainerGap()));
    }

    private void pythonComboBoxActionPerformed(ActionEvent evt) {
        this.markChange();
    }

    private void loadProperties() {
        try (FileConfig conf = FileConfig.of((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory().getFileObject("pyproject.toml")));){
            String lspPythonExe;
            String poetryPythonPath;
            conf.load();
            boolean isPoetry = PythonUtility.isPoetry(this.project);
            projectNameTextField.setText((String)conf.getOrElse(isPoetry ? "tool.poetry.name" : "project.name", (Object)this.project.getProjectDirectory().getName()));
            versionTextField.setText((String)conf.get(isPoetry ? "tool.poetry.version" : "project.version"));
            descriptionTextArea.setText((String)conf.get(isPoetry ? "tool.poetry.description" : "project.description"));
            FileObject projectDirectory = this.project.getProjectDirectory();
            FileObject fileObjectW = projectDirectory.getFileObject(".venv\\Scripts\\python", "exe");
            FileObject fileObjectP = projectDirectory.getFileObject(".venv/bin/python");
            HashSet<Pair> pyPlat = new HashSet<Pair>();
            if (fileObjectW != null) {
                pyPlat.add(Pair.of((Object)("(.venv) " + PythonUtility.getVersion(Paths.get(fileObjectW.getPath(), new String[0]).toString())), (Object)Paths.get(fileObjectW.getPath(), new String[0]).toString()));
            } else if (fileObjectP != null) {
                pyPlat.add(Pair.of((Object)("(.venv) " + PythonUtility.getVersion(Paths.get(fileObjectP.getPath(), new String[0]).toString())), (Object)Paths.get(fileObjectP.getPath(), new String[0]).toString()));
            } else if (isPoetry && !(poetryPythonPath = PythonUtility.getPoetryPythonPath(lspPythonExe = PythonUtility.getLspPythonExe(), this.project.getProjectDirectory())).equals(lspPythonExe)) {
                pyPlat.add(Pair.of((Object)PythonUtility.getVersion(poetryPythonPath), (Object)poetryPythonPath));
            }
            Properties prop = PythonUtility.getProperties(this.project, false);
            Object python_path = prop.get("nbproject.python_path");
            if (python_path != null && !python_path.toString().isEmpty()) {
                pyPlat.add(Pair.of((Object)PythonUtility.getVersion(python_path.toString()), (Object)python_path.toString()));
            }
            for (Pair pair : pyPlat) {
                pythonComboBox.addItem(pair);
            }
            for (Quartet quartet : PythonPlatformManager.getPythonExes()) {
                String exe = (String)quartet.getValue1();
                Pair of = Pair.of((Object)((String)quartet.getValue0()), (Object)exe);
                if (exe.equals(python_path)) {
                    pythonComboBox.setSelectedItem(of);
                    continue;
                }
                pythonComboBox.addItem(of);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void setProperties(PythonProject project) {
        Object selectedItem = pythonComboBox.getSelectedItem();
        try {
            File toFile = FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("pyproject.toml"));
            String projectName = projectNameTextField.getText();
            String version = versionTextField.getText();
            String descr = descriptionTextArea.getText();
            String py = selectedItem != null ? ">=" + StringUtils.remove((String)((Pair)selectedItem).first().toString(), (String)"Python ").replace("(.venv) ", "") : "";
            File tomlHandler = PythonUtility.TOML_HANDLER;
            String[] cmd = new String[]{PythonUtility.getLspPythonExe(), tomlHandler.toPath().toString(), toFile.toPath().toString(), projectName, version, descr, py, PythonUtility.getProjectType(toFile)};
            PythonUtility.processExecutor(cmd, "Update Properties");
            Properties prop = PythonUtility.getProperties(project, false);
            prop.setProperty("nbproject.python_path", selectedItem != null ? ((Pair)selectedItem).second().toString() : "");
            prop.store(new FileWriter(FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"))), null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.markChange();
    }

    void markChange() {
        ((PythonProjectStateHandler)this.project.getLookup().lookup(PythonProjectStateHandler.class)).mark();
    }
}

