/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.projectproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.modules.python.project.PythonProjectStateHandler;
import org.netbeans.modules.python.projectproperties.PythonFrameworkCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PythonTestPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    PythonProject project;
    private JButton testDirButton;
    private JFileChooser testFrameworkChooserFileChooser;
    public static JComboBox<String> testFrameworkComboBox;
    private JLabel testFrameworkDirLabel;
    private static JTextField testFrameworkDirTextField;
    private JLabel testFrameworkLabel;
    private JPanel testFrameworkPanel;
    private JLabel testFrameworkParamsLabel;
    private static JTextField testFrameworkParamsTextField;
    private JFileChooser testGeneratorChooserFileChooser;
    private static JComboBox<String> testGeneratorComboBox;
    private JButton testGeneratorDirButton;
    private JLabel testGeneratorDirLabel;
    private static JTextField testGeneratorDirTextField;
    private JLabel testGeneratorLabel;
    private JPanel testGeneratorPanel;
    private JLabel testGeneratorParamsLabel;
    private static JTextField testGeneratorParamsTextField;

    public PythonTestPanel(PythonProject project) {
        this.initComponents();
        testFrameworkComboBox.setRenderer(new PythonFrameworkCellRenderer());
        testGeneratorComboBox.setRenderer(new PythonFrameworkCellRenderer());
        testFrameworkParamsTextField.getDocument().addDocumentListener(this);
        testGeneratorDirTextField.getDocument().addDocumentListener(this);
        this.project = project;
        this.loadProperties();
    }

    private void initComponents() {
        this.testFrameworkChooserFileChooser = new JFileChooser();
        this.testGeneratorChooserFileChooser = new JFileChooser();
        this.testGeneratorPanel = new JPanel();
        this.testGeneratorLabel = new JLabel();
        testGeneratorComboBox = new JComboBox();
        this.testGeneratorParamsLabel = new JLabel();
        testGeneratorParamsTextField = new JTextField();
        this.testGeneratorDirLabel = new JLabel();
        testGeneratorDirTextField = new JTextField();
        this.testGeneratorDirButton = new JButton();
        this.testFrameworkPanel = new JPanel();
        this.testFrameworkLabel = new JLabel();
        this.testFrameworkParamsLabel = new JLabel();
        testFrameworkComboBox = new JComboBox();
        testFrameworkParamsTextField = new JTextField();
        this.testFrameworkDirLabel = new JLabel();
        testFrameworkDirTextField = new JTextField();
        this.testDirButton = new JButton();
        this.testFrameworkChooserFileChooser.setDialogType(1);
        this.testFrameworkChooserFileChooser.setFileSelectionMode(1);
        this.testGeneratorChooserFileChooser.setDialogType(1);
        this.testGeneratorChooserFileChooser.setFileSelectionMode(1);
        this.setLayout(new BorderLayout());
        this.testGeneratorPanel.setBorder(BorderFactory.createTitledBorder(null, NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testGeneratorPanel.border.title"), 0, 0, new Font("Segoe UI", 1, 12)));
        Mnemonics.setLocalizedText((JLabel)this.testGeneratorLabel, (String)NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testGeneratorLabel.text"));
        testGeneratorComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"pynguin"}));
        testGeneratorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonTestPanel.this.testGeneratorComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.testGeneratorParamsLabel, (String)NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testGeneratorParamsLabel.text"));
        testGeneratorParamsTextField.setText(NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testGeneratorParamsTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.testGeneratorDirLabel, (String)NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testGeneratorDirLabel.text"));
        testGeneratorDirTextField.setText(NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testGeneratorDirTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testGeneratorDirButton, (String)NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testGeneratorDirButton.text"));
        this.testGeneratorDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonTestPanel.this.testGeneratorDirButtonActionPerformed(evt);
            }
        });
        GroupLayout testGeneratorPanelLayout = new GroupLayout(this.testGeneratorPanel);
        this.testGeneratorPanel.setLayout(testGeneratorPanelLayout);
        testGeneratorPanelLayout.setHorizontalGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testGeneratorPanelLayout.createSequentialGroup().addContainerGap().addGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testGeneratorLabel).addComponent(this.testGeneratorParamsLabel).addComponent(this.testGeneratorDirLabel)).addGap(25, 25, 25).addGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(testGeneratorParamsTextField, -1, 400, Short.MAX_VALUE).addGroup(testGeneratorPanelLayout.createSequentialGroup().addComponent(testGeneratorDirTextField, -1, 322, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testGeneratorDirButton)).addComponent(testGeneratorComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        testGeneratorPanelLayout.setVerticalGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testGeneratorPanelLayout.createSequentialGroup().addGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testGeneratorLabel).addComponent(testGeneratorComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testGeneratorParamsLabel).addComponent(testGeneratorParamsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testGeneratorDirLabel).addComponent(testGeneratorDirTextField, -2, -1, -2).addComponent(this.testGeneratorDirButton)).addGap(0, 0, Short.MAX_VALUE)));
        this.add((Component)this.testGeneratorPanel, "Center");
        this.testFrameworkPanel.setBorder(BorderFactory.createTitledBorder(null, NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testFrameworkPanel.border.title"), 0, 0, new Font("Segoe UI", 1, 12)));
        Mnemonics.setLocalizedText((JLabel)this.testFrameworkLabel, (String)NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testFrameworkLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.testFrameworkParamsLabel, (String)NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testFrameworkParamsLabel.text"));
        testFrameworkComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"unittest", "pytest"}));
        testFrameworkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonTestPanel.this.testFrameworkComboBoxActionPerformed(evt);
            }
        });
        testFrameworkParamsTextField.setText(NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testFrameworkParamsTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.testFrameworkDirLabel, (String)NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testFrameworkDirLabel.text"));
        testFrameworkDirTextField.setText(NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testFrameworkDirTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testDirButton, (String)NbBundle.getMessage(PythonTestPanel.class, (String)"PythonTestPanel.testDirButton.text"));
        this.testDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonTestPanel.this.testDirButtonActionPerformed(evt);
            }
        });
        GroupLayout testFrameworkPanelLayout = new GroupLayout(this.testFrameworkPanel);
        this.testFrameworkPanel.setLayout(testFrameworkPanelLayout);
        testFrameworkPanelLayout.setHorizontalGroup(testFrameworkPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testFrameworkPanelLayout.createSequentialGroup().addContainerGap().addGroup(testFrameworkPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testFrameworkDirLabel).addComponent(this.testFrameworkParamsLabel).addComponent(this.testFrameworkLabel)).addGap(55, 55, 55).addGroup(testFrameworkPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, testFrameworkPanelLayout.createSequentialGroup().addComponent(testFrameworkDirTextField, -1, 296, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testDirButton)).addGroup(testFrameworkPanelLayout.createSequentialGroup().addComponent(testFrameworkParamsTextField, -1, 379, Short.MAX_VALUE).addGap(1, 1, 1)).addComponent(testFrameworkComboBox, 0, 380, Short.MAX_VALUE)).addContainerGap()));
        testFrameworkPanelLayout.setVerticalGroup(testFrameworkPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testFrameworkPanelLayout.createSequentialGroup().addGroup(testFrameworkPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testFrameworkLabel).addComponent(testFrameworkComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(testFrameworkPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testFrameworkParamsLabel).addComponent(testFrameworkParamsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(testFrameworkPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testFrameworkDirLabel).addComponent(testFrameworkDirTextField, -2, -1, -2).addComponent(this.testDirButton)).addGap(0, 0, Short.MAX_VALUE)));
        this.add((Component)this.testFrameworkPanel, "First");
    }

    private void testDirButtonActionPerformed(ActionEvent evt) {
        this.testFrameworkChooserFileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        int returnValue = this.testFrameworkChooserFileChooser.showSaveDialog(null);
        if (returnValue == 0) {
            testFrameworkDirTextField.setText(this.testFrameworkChooserFileChooser.getSelectedFile().toPath().toString());
            this.markChange();
        }
    }

    private void testGeneratorDirButtonActionPerformed(ActionEvent evt) {
        this.testGeneratorChooserFileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        int returnValue = this.testGeneratorChooserFileChooser.showSaveDialog(null);
        if (returnValue == 0) {
            testGeneratorDirTextField.setText(this.testGeneratorChooserFileChooser.getSelectedFile().toPath().toString());
            this.markChange();
        }
    }

    private void testFrameworkComboBoxActionPerformed(ActionEvent evt) {
        this.markChange();
    }

    private void testGeneratorComboBoxActionPerformed(ActionEvent evt) {
        this.markChange();
    }

    private void loadProperties() {
        try {
            Properties prop = PythonUtility.getProperties(this.project, false);
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("tests");
            FileObject fileObjectG = this.project.getProjectDirectory().getFileObject("tests/pynguin-tests");
            testFrameworkComboBox.setSelectedItem(prop.getProperty("nbproject.test.runner", "print"));
            testFrameworkParamsTextField.setText(prop.getProperty("nbproject.test.params", ""));
            testFrameworkDirTextField.setText(prop.getProperty("nbproject.test.dir", fileObject != null ? Paths.get(fileObject.getPath(), new String[0]).toString() : ""));
            testGeneratorDirTextField.setText(prop.getProperty("nbproject.test.generator.dir", fileObjectG != null ? Paths.get(fileObjectG.getPath(), new String[0]).toString() : ""));
            testGeneratorComboBox.setSelectedIndex(0);
            testGeneratorParamsTextField.setText(prop.getProperty("nbproject.test.generator.params", ""));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void setProperties(PythonProject project) {
        try {
            Properties prop = PythonUtility.getProperties(project, false);
            prop.setProperty("nbproject.test.runner", testFrameworkComboBox.getSelectedItem().toString());
            prop.setProperty("nbproject.test.params", testFrameworkParamsTextField.getText());
            prop.setProperty("nbproject.test.dir", testFrameworkDirTextField.getText());
            prop.setProperty("nbproject.test.generator.dir", testGeneratorDirTextField.getText());
            prop.setProperty("nbproject.test.generator.runner", testGeneratorComboBox.getSelectedItem().toString());
            prop.setProperty("nbproject.test.generator.params", testGeneratorParamsTextField.getText());
            prop.store(new FileWriter(FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"))), null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void markChange() {
        ((PythonProjectStateHandler)this.project.getLookup().lookup(PythonProjectStateHandler.class)).mark();
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.markChange();
    }
}

