/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.source;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.math3.util.Precision;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.spi.editor.SideBarFactory;
import org.openide.awt.CloseButtonFactory;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PythonPylintScoreBar
extends JPanel {
    private boolean enabled;
    private static final String PYLINT_SIDEBAR_PROP = "pylintSideBar";
    FileObject fileForDocument;
    static Pattern PYLINT_SCORE = Pattern.compile("Your code has been rated at (.*) \\(previous run: (.*), (.*)\\)|Your code has been rated at (.*)");
    DataObject find;
    static RequestProcessor RP = new RequestProcessor(PythonPylintScoreBar.class.getName(), 5);
    PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("modified")) {
                PythonPylintScoreBar.this.setScore(PythonPylintScoreBar.this.fileForDocument);
            }
        }
    };
    private JLabel nameLabel;
    private JLabel previousLabel;
    private JProgressBar pylintProgressBar;
    private JPanel pylintScorePanel;

    public PythonPylintScoreBar(JTextComponent target) {
        Document document = target.getDocument();
        String mimeType = (String)document.getProperty("mimeType");
        if (!mimeType.equals("text/x-python")) {
            return;
        }
        this.fileForDocument = GsfUtilities.findFileObject((Document)document);
        try {
            this.find = DataObject.find((FileObject)this.fileForDocument);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        boolean on = false;
        if (on) {
            this.showScorePanel(true);
        } else {
            this.updatePreferredSize();
        }
        target.putClientProperty(PYLINT_SIDEBAR_PROP, this);
    }

    private void initComponents() {
        this.pylintScorePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.pylintProgressBar = new JProgressBar();
        this.previousLabel = new JLabel();
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(PythonPylintScoreBar.class, (String)"PythonPylintScoreBar.nameLabel.text"));
        this.nameLabel.setToolTipText(NbBundle.getMessage(PythonPylintScoreBar.class, (String)"PythonPylintScoreBar.nameLabel.toolTipText"));
        this.nameLabel.setPreferredSize(new Dimension(102, 19));
        this.pylintProgressBar.setBackground(new Color(180, 50, 50));
        this.pylintProgressBar.setFont(new Font("Cantarell", 1, 15));
        this.pylintProgressBar.setPreferredSize(new Dimension(146, 23));
        this.pylintProgressBar.setString(NbBundle.getMessage(PythonPylintScoreBar.class, (String)"PythonPylintScoreBar.pylintProgressBar.string"));
        this.pylintProgressBar.setStringPainted(true);
        this.pylintProgressBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PythonPylintScoreBar.this.pylintProgressBarStateChanged(evt);
            }
        });
        this.previousLabel.setFont(new Font("Cantarell", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.previousLabel, (String)NbBundle.getMessage(PythonPylintScoreBar.class, (String)"PythonPylintScoreBar.previousLabel.text"));
        GroupLayout pylintScorePanelLayout = new GroupLayout(this.pylintScorePanel);
        this.pylintScorePanel.setLayout(pylintScorePanelLayout);
        pylintScorePanelLayout.setHorizontalGroup(pylintScorePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pylintScorePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.nameLabel, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pylintProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previousLabel).addContainerGap(-1, Short.MAX_VALUE)));
        pylintScorePanelLayout.setVerticalGroup(pylintScorePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pylintScorePanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pylintScorePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel, -2, -1, -2).addComponent(this.pylintProgressBar, -2, -1, -2).addComponent(this.previousLabel)).addGap(0, 0, 0)));
        pylintScorePanelLayout.linkSize(1, this.nameLabel, this.pylintProgressBar);
        this.add((Component)this.pylintScorePanel, "Center");
    }

    private void pylintProgressBarStateChanged(ChangeEvent evt) {
        int percentComplete = this.pylintProgressBar.getValue();
        if ((double)percentComplete <= 33.33) {
            this.pylintProgressBar.setForeground(new Color(180, 50, 50));
        } else if ((double)percentComplete > 33.33 && (double)percentComplete <= 66.66) {
            this.pylintProgressBar.setForeground(UIManager.getDefaults().getColor("nb.warningForeground"));
        } else {
            this.pylintProgressBar.setForeground(new Color(30, 180, 30));
        }
    }

    public static PythonPylintScoreBar getSideBar(JTextComponent target) {
        return (PythonPylintScoreBar)target.getClientProperty(PYLINT_SIDEBAR_PROP);
    }

    public void showScorePanel(boolean on) {
        if (on == this.enabled) {
            return;
        }
        this.enabled = on;
        if (on) {
            this.initComponents();
            JButton closeButton = CloseButtonFactory.createBigCloseButton();
            this.add((Component)closeButton, "East");
            closeButton.addActionListener(e -> {
                this.showScorePanel(false);
                this.find.removePropertyChangeListener(this.pcl);
            });
            this.setScore(this.fileForDocument);
            this.find.addPropertyChangeListener(this.pcl);
        } else {
            this.removeAll();
        }
        this.updatePreferredSize();
        this.revalidate();
        this.repaint();
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.setPreferredSize(null);
            Dimension preferred = this.getPreferredSize();
            this.setPreferredSize(preferred);
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private void setScore(FileObject fileForDocument) {
        RP.post(() -> {
            try {
                String[] cmd = new String[]{PythonUtility.getLspPythonExe(), "-m", "pylint", Paths.get(fileForDocument.getPath(), new String[0]).toString()};
                String commandOutput = PythonUtility.getCommandOutput(cmd, null);
                PYLINT_SCORE.matcher(commandOutput).results().forEach(match -> {
                    String score = match.group(1);
                    String previous = match.group(2);
                    String delta = match.group(3);
                    String onlyScore = match.group(4);
                    if (onlyScore != null) {
                        double percentage = Precision.round((double)this.getPercentage(onlyScore), (int)2);
                        this.pylintProgressBar.setValue((int)Math.round(percentage));
                        this.pylintProgressBar.setString(String.format("%s %s", Double.toString(percentage), "%"));
                    } else {
                        double percentage = Precision.round((double)this.getPercentage(score), (int)2);
                        this.pylintProgressBar.setValue((int)Math.round(percentage));
                        this.pylintProgressBar.setString(String.format("%s %s", Double.toString(percentage), "%"));
                        this.previousLabel.setText(String.format("(previous run: %s, %s)", previous, delta));
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    private double getPercentage(String onlyScore) {
        String[] split = onlyScore.split("/");
        double perc = NumberUtils.toDouble((String)split[0]) / 10.0 * 100.0;
        return perc;
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            return new PythonPylintScoreBar(target);
        }
    }
}

