/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.tasklist;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class PythonDiagCollector {
    static String[] UNNECESSITY_CODES = new String[]{"F401", "F504", "F522", "F523", "F841"};
    public static List<ErrorDescription> errors;
    public static Pattern DIAG_REG;

    private static String getOutput(FileObject fo) {
        try {
            if (fo == null) {
                return "";
            }
            return PythonUtility.getCommandOutput(new String[]{PythonUtility.getLspPythonExe(), "-m", "flake8", Paths.get(fo.getPath(), new String[0]).toString()}, null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "";
        }
    }

    public static void parse(Source source, boolean projectOrNot) {
        PythonDiagCollector.format(PythonDiagCollector.getOutput(source.getFileObject()), source, projectOrNot);
    }

    private static void format(String diagOutput, Source source, boolean projectOrNot) {
        errors = new ArrayList<ErrorDescription>();
        diagOutput.lines().forEach(diag -> {
            Matcher matcher = DIAG_REG.matcher((CharSequence)diag);
            if (matcher.find()) {
                ErrorDescription createErrorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)PythonDiagCollector.getSeverity(matcher.group(4)), (String)matcher.group(5), (Document)source.getDocument(projectOrNot), (int)Integer.parseInt(matcher.group(2)));
                errors.add(createErrorDescription);
            }
        });
    }

    public static Severity getSeverity(String code) {
        Severity severity = Severity.WARNING;
        if (code.equals("E999") || code.startsWith("F") && !StringUtils.equalsAny((CharSequence)code, (CharSequence[])UNNECESSITY_CODES)) {
            severity = Severity.ERROR;
        }
        return severity;
    }

    public static boolean hasErrors(FileObject fo) {
        try {
            if (!fo.isFolder() && !fo.getMIMEType().equals("text/x-python")) {
                return false;
            }
            ProcessBuilder p = new ProcessBuilder(PythonUtility.getLspPythonExe(), "-m", "pyflakes", Paths.get(fo.getPath(), new String[0]).toString());
            return !IOUtils.toString((InputStream)p.redirectErrorStream(true).start().getInputStream(), (Charset)StandardCharsets.UTF_8).strip().isEmpty();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    static {
        DIAG_REG = Pattern.compile("(.*):(\\d*):(\\d*): (\\w*) (.*)");
    }
}

