/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.testrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PythonTestLocator
implements TestLocator {
    private static final RequestProcessor RP = new RequestProcessor(PythonTestLocator.class.getName(), 2);
    private static final Logger LOGGER = Logger.getLogger(PythonTestLocator.class.getName());
    static final Comparator<File> FILE_OBJECT_COMAPARTOR = new FileComparator();

    public boolean appliesTo(FileObject fo) {
        Project project = PythonTestLocator.findProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "Project was not found for file {0}", fo);
            return false;
        }
        return fo.getMIMEType().equals("text/x-python");
    }

    @CheckForNull
    private static Project findProject(FileObject file) {
        return FileOwnerQuery.getOwner((FileObject)file);
    }

    public boolean asynchronous() {
        return true;
    }

    public TestLocator.LocationResult findOpposite(FileObject fo, int caretOffset) {
        throw new UnsupportedOperationException("Go To Test is asynchronous");
    }

    public void findOpposite(FileObject fo, int caretOffset, TestLocator.LocationListener callback) {
        RP.post(() -> callback.foundLocation(fo, this.findOpposite(fo)));
    }

    private TestLocator.LocationResult findOpposite(FileObject fo) {
        String mimeType = FileUtil.getMIMEType((FileObject)fo);
        if ("text/x-python".equals(mimeType)) {
            FileObject test = PythonTestLocator.findOpposite(fo, true);
            if (test != null) {
                return new TestLocator.LocationResult(test, -1);
            }
            return new TestLocator.LocationResult("Test not found.");
        }
        throw new IllegalArgumentException();
    }

    public TestLocator.FileType getFileType(FileObject fo) {
        String mimeType = FileUtil.getMIMEType((FileObject)fo);
        String name = fo.getName();
        if (mimeType.equals("text/x-python")) {
            return TestLocator.FileType.TESTED;
        }
        if (name.endsWith("Test")) {
            return TestLocator.FileType.TEST;
        }
        return TestLocator.FileType.NEITHER;
    }

    @CheckForNull
    static FileObject findOpposite(FileObject fo, boolean toTest) {
        SourceGroup[] sourceGroups;
        boolean testedFile = fo.getName().endsWith("Test");
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        String projectDirectoryPath = Paths.get(owner.getProjectDirectory().getPath(), new String[0]).toString();
        for (SourceGroup sg : sourceGroups = ProjectUtils.getSources((Project)owner).getSourceGroups(testedFile ? "generic" : "testsources")) {
            File toFile = FileUtil.toFile((FileObject)sg.getRootFolder());
            try {
                List listFiles = Files.walk(toFile.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(file -> file.isFile() && StringUtils.endsWith((CharSequence)FileUtil.toFile((FileObject)fo).toPath().toString(), (CharSequence)(!testedFile ? StringUtils.remove((String)StringUtils.remove((String)file.toPath().toString(), (String)toFile.toPath().toString()), (String)"Test") : StringUtils.remove((String)file.toPath().toString(), (String)projectDirectoryPath).replace(".py", "Test.py")))).collect(Collectors.toList());
                listFiles.sort(FILE_OBJECT_COMAPARTOR);
                return listFiles.isEmpty() ? null : FileUtil.toFileObject((File)((File)listFiles.get(listFiles.size() - 1)));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File fo1, File fo2) {
            return fo1.toPath().toString().compareTo(fo2.toPath().toString());
        }
    }
}

