/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.testrunner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.python.testrunner.PythonTestMethodAnnotation;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

class PythonTestMethodController {
    static Pattern TEST_CLASS = Pattern.compile(".*\\nclass\\s+([^\\(|:]+).*:");
    static Pattern TEST_METHOD = Pattern.compile(".*def\\s+(test_[^\\(|:]+).*:");

    PythonTestMethodController() {
    }

    static void setMethods(Snapshot snapshot) {
        try {
            FileObject fo = snapshot.getSource().getFileObject();
            StyledDocument document = ((EditorCookie)DataObject.find((FileObject)fo).getLookup().lookup(EditorCookie.class)).getDocument();
            List<TestMethodController.TestMethod> computeMethods = PythonTestMethodController.computeMethods(document);
            if (computeMethods == null || computeMethods.isEmpty()) {
                return;
            }
            NbDocument.runAtomic((StyledDocument)document, () -> PythonTestMethodController.setTestMethodsImpl(document, computeMethods));
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void setTestMethodsImpl(StyledDocument doc, List<TestMethodController.TestMethod> methods) {
        HashMap<Integer, TestMethodController.TestMethod> annotationLines;
        doc.putProperty(PythonTestMethodAnnotation.DOCUMENT_METHODS_KEY, methods);
        HashMap<TestMethodController.TestMethod, PythonTestMethodAnnotation> annotations = (HashMap<TestMethodController.TestMethod, PythonTestMethodAnnotation>)doc.getProperty(PythonTestMethodAnnotation.DOCUMENT_ANNOTATIONS_KEY);
        if (annotations == null) {
            annotations = new HashMap<TestMethodController.TestMethod, PythonTestMethodAnnotation>();
            doc.putProperty(PythonTestMethodAnnotation.DOCUMENT_ANNOTATIONS_KEY, annotations);
        }
        if ((annotationLines = (HashMap<Integer, TestMethodController.TestMethod>)doc.getProperty(PythonTestMethodAnnotation.DOCUMENT_ANNOTATION_LINES_KEY)) == null) {
            annotationLines = new HashMap<Integer, TestMethodController.TestMethod>();
            doc.putProperty(PythonTestMethodAnnotation.DOCUMENT_ANNOTATION_LINES_KEY, annotationLines);
        }
        HashMap removed = new HashMap(annotations);
        methods.forEach(tm -> removed.remove(tm));
        HashSet<TestMethodController.TestMethod> added = new HashSet<TestMethodController.TestMethod>(methods);
        added.removeAll(annotations.keySet());
        for (TestMethodController.TestMethod testMethod : added) {
            PythonTestMethodAnnotation a = new PythonTestMethodAnnotation(testMethod);
            NbDocument.addAnnotation((StyledDocument)doc, (Position)testMethod.preferred(), (int)0, (Annotation)a);
            annotations.put(testMethod, a);
            int line = NbDocument.findLineNumber((StyledDocument)doc, (int)testMethod.preferred().getOffset());
            annotationLines.put(line, testMethod);
        }
        for (Map.Entry entry : removed.entrySet()) {
            NbDocument.removeAnnotation((StyledDocument)doc, (Annotation)((Annotation)entry.getValue()));
            annotations.remove(entry.getKey());
            int line = NbDocument.findLineNumber((StyledDocument)doc, (int)((TestMethodController.TestMethod)entry.getKey()).preferred().getOffset());
            annotationLines.remove(line);
        }
    }

    private static List<TestMethodController.TestMethod> computeMethods(StyledDocument doc) {
        if (doc == null) {
            return null;
        }
        FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
        if (!PythonTestMethodController.isUnderTestSources(fo)) {
            return null;
        }
        ArrayList<TestMethodController.TestMethod> methods = new ArrayList<TestMethodController.TestMethod>();
        try {
            String currentFile = doc.getText(0, doc.getEndPosition().getOffset());
            Stream<MatchResult> classResults = TEST_CLASS.matcher(currentFile).results();
            if (classResults.count() == 0L) {
                return null;
            }
            TEST_METHOD.matcher(currentFile).results().forEach(methodMatch -> {
                try {
                    int startOffset = methodMatch.start(1);
                    MatchResult classGroup = TEST_CLASS.matcher(currentFile).results().filter(classMatch -> classMatch.end(1) < startOffset).reduce((first, second) -> second).orElse(null);
                    if (classGroup != null) {
                        String className = classGroup.group(1);
                        String testMethodName = methodMatch.group(1);
                        Position start = NbDocument.createPosition((Document)doc, (int)startOffset, (Position.Bias)Position.Bias.Forward);
                        Position end = NbDocument.createPosition((Document)doc, (int)methodMatch.end(1), (Position.Bias)Position.Bias.Backward);
                        methods.add(new TestMethodController.TestMethod(className, new SingleMethod(fo, testMethodName), start, start, end));
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return methods;
    }

    private static boolean isUnderTestSources(FileObject fo) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return false;
        }
        for (SourceGroup dir : ProjectUtils.getSources((Project)owner).getSourceGroups("testsources")) {
            if (!FileUtil.isParentOf((FileObject)dir.getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }
}

