/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.testrunner;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.math.NumberUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.ui.api.CallstackFrameNode;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.ui.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PythonTestNodeFactory
extends TestRunnerNodeFactory {
    public Node createTestMethodNode(Testcase tstcs, Project prjct) {
        return new PythonTestMethodNode(tstcs, prjct);
    }

    public Node createCallstackFrameNode(String string, String string1) {
        return new PythonCallstackFrameNode(string, string1);
    }

    public TestsuiteNode createTestSuiteNode(String string, boolean bln) {
        return new PythonTestSuiteNode(string, bln);
    }

    private static class PythonJumpTestAction
    extends AbstractAction {
        private static final RequestProcessor RP = new RequestProcessor(PythonJumpTestAction.class);
        Testcase testcase;
        Project project;

        public PythonJumpTestAction(Testcase testcase, Project project) {
            this.testcase = testcase;
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String loc = this.testcase.getLocation();
            if (loc != null) {
                String[] location = loc.split("##");
                SwingUtilities.invokeLater(() -> {
                    try {
                        DataObject dobj;
                        FileObject toFileObject = FileUtil.toFileObject((File)new File(location[0]));
                        if (toFileObject != null && (dobj = DataObject.find((FileObject)toFileObject)) != null) {
                            LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                            if (lc == null) {
                                return;
                            }
                            Line l = lc.getLineSet().getOriginal(NumberUtils.toInt((String)location[1], (int)0));
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
            }
        }
    }

    private static class PythonTestSuiteNode
    extends TestsuiteNode {
        public PythonTestSuiteNode(String suiteName, boolean filtered) {
            super(suiteName, filtered);
        }
    }

    private static class PythonCallstackFrameNode
    extends CallstackFrameNode {
        public PythonCallstackFrameNode(String frameInfo, String displayName) {
            super(frameInfo, displayName);
        }
    }

    private static class PythonTestMethodNode
    extends TestMethodNode {
        Testcase testcase;
        Project project;

        public PythonTestMethodNode(Testcase testcase, Project project) {
            super(testcase, project);
            this.testcase = testcase;
            this.project = project;
        }

        public Action getPreferredAction() {
            return new PythonJumpTestAction(this.testcase, this.project);
        }
    }
}

