/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.arithmetics;

public class Arithmetics {
    public static long gcd(long a, long b) {
        while (b != 0L) {
            long r = b;
            b = a % b;
            a = r;
        }
        return a;
    }

    public static long lcm(long a, long b) {
        return a * b / Arithmetics.gcd(a, b);
    }

    public static Pair bezoutCoefficients(long a, long b) {
        long s = 0L;
        long old_s = 1L;
        long t = 1L;
        long old_t = 0L;
        long r = b;
        long old_r = a;
        while (r != 0L) {
            long q = old_r / r;
            long prov = r;
            r = old_r - q * prov;
            old_r = prov;
            prov = s;
            s = old_s - q * prov;
            old_s = prov;
            prov = t;
            t = old_t - q * prov;
            old_t = prov;
        }
        return new Pair(old_s, old_t);
    }

    public record Pair(long u, long v) {
    }
}

