/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.arithmetics;

import org.tech.vineyard.arithmetics.ModularArithmetics;

public class ModularAlgebra {
    private final ModularArithmetics modularArithmetics;
    private final int m;

    public ModularAlgebra(int m) {
        this.m = m;
        this.modularArithmetics = new ModularArithmetics(m);
    }

    public int[] multiply(int[][] m, int[] a) {
        int N = m.length;
        int[] b = new int[N];
        for (int i = 0; i < N; ++i) {
            b[i] = this.dotProduct(m[i], a);
        }
        return b;
    }

    private int[][] multiply(int[][] m, int[][] n) {
        int N = m.length;
        int M = n[0].length;
        int[][] p = new int[N][M];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < M; ++j) {
                p[i][j] = this.dotProduct(m[i], n, j);
            }
        }
        return p;
    }

    private int dotProduct(int[] a, int[][] m, int j) {
        int M = a.length;
        int sum = 0;
        for (int k = 0; k < M; ++k) {
            sum = this.add(sum, this.multiply(a[k], m[k][j]));
        }
        return sum;
    }

    private int dotProduct(int[] a, int[] b) {
        int M = a.length;
        int sum = 0;
        for (int j = 0; j < M; ++j) {
            sum = this.add(sum, this.multiply(a[j], b[j]));
        }
        return sum;
    }

    public int[][] exponent(int[][] m, int e) {
        int N = m.length;
        int[][] p = this.identity(N);
        while (e > 0) {
            if ((e & 1) == 1) {
                p = this.multiply(m, p);
            }
            m = this.square(m);
            e >>= 1;
        }
        return p;
    }

    private int[][] square(int[][] m) {
        return this.multiply(m, m);
    }

    private int[][] identity(int N) {
        int[][] identity = new int[N][N];
        for (int i = 0; i < N; ++i) {
            identity[i][i] = 1;
        }
        return identity;
    }

    private int multiply(int a, int b) {
        return this.modularArithmetics.multiply(a, b);
    }

    private int add(int a, int b) {
        return this.modularArithmetics.add(a, b);
    }
}

