/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.arithmetics;

public class ModularArithmetics {
    private final int m;

    public ModularArithmetics(int m) {
        this.m = m;
    }

    public int getMod() {
        return this.m;
    }

    public int exponent(int b, int e) {
        int pow = 1;
        int base = b % this.m;
        for (int exponent = e; exponent > 0; exponent >>= 1) {
            if ((exponent & 1) != 0) {
                pow = this.multiply(pow, base);
            }
            base = this.multiply(base, base);
        }
        return pow;
    }

    public int multiply(int a, int b) {
        return (int)(1L * (long)a * (long)b % (long)this.m);
    }

    public int square(int a) {
        return this.multiply(a, a);
    }

    public int add(int a, int b) {
        return (a + b) % this.m;
    }

    public int subtract(int a, int b) {
        return this.positive(a - b);
    }

    private int positive(int a) {
        return (a % this.m + this.m) % this.m;
    }

    public int inverse(int a) {
        int u = this.bezoutCoefficient(a, this.m);
        return this.positive(u);
    }

    private int bezoutCoefficient(int a, int b) {
        int s = 0;
        int old_s = 1;
        int t = 1;
        int old_t = 0;
        int r = b;
        int old_r = a;
        while (r != 0) {
            int q = old_r / r;
            int prov = r;
            r = old_r - q * prov;
            old_r = prov;
            prov = s;
            s = old_s - q * prov;
            old_s = prov;
            prov = t;
            t = old_t - q * prov;
            old_t = prov;
        }
        return old_s;
    }

    public int divide(int a, int b) {
        return this.multiply(a, this.inverse(b));
    }

    public int inversePrime(int a) {
        return this.exponent(a, this.m - 2);
    }
}

