/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.arithmetics.prime.factorization;

import java.util.ArrayList;
import java.util.List;
import org.tech.vineyard.arithmetics.prime.factorization.PrimeFactor;
import org.tech.vineyard.arithmetics.prime.factorization.PrimeFactorization;

public class DivisorPrimeFactorization
implements PrimeFactorization {
    @Override
    public List<PrimeFactor> factors(int a) {
        ArrayList<PrimeFactor> primeFactors = new ArrayList<PrimeFactor>();
        int divisor = 2;
        while (divisor * divisor <= a) {
            if (a % divisor == 0) {
                int exponent = 0;
                while (a % divisor == 0) {
                    a /= divisor;
                    ++exponent;
                }
                primeFactors.add(new PrimeFactor(divisor, exponent));
            }
            ++divisor;
        }
        if (a != 1) {
            primeFactors.add(new PrimeFactor(a, 1));
        }
        return primeFactors;
    }
}

