/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.arithmetics.prime.factorization;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class PollardRhoPrimeFactorization {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final SecureRandom random = new SecureRandom();
    private Map<BigInteger, Integer> factors = new HashMap<BigInteger, Integer>();

    public PollardRhoPrimeFactorization(BigInteger n) {
        this.factor(n);
    }

    public BigInteger rho(BigInteger N) {
        BigInteger divisor;
        BigInteger x;
        BigInteger c = new BigInteger(N.bitLength(), random);
        BigInteger xx = x = new BigInteger(N.bitLength(), random);
        if (N.mod(TWO).compareTo(ZERO) == 0) {
            return TWO;
        }
        do {
            x = x.multiply(x).mod(N).add(c).mod(N);
            xx = xx.multiply(xx).mod(N).add(c).mod(N);
        } while ((divisor = x.subtract(xx = xx.multiply(xx).mod(N).add(c).mod(N)).gcd(N)).compareTo(ONE) == 0);
        return divisor;
    }

    public void factor(BigInteger N) {
        if (N.compareTo(ONE) == 0) {
            return;
        }
        if (N.isProbablePrime(8)) {
            this.incrementExponent(N);
            return;
        }
        BigInteger divisor = this.rho(N);
        this.factor(divisor);
        this.factor(N.divide(divisor));
    }

    public Map<BigInteger, Integer> factors() {
        return this.factors;
    }

    private void incrementExponent(BigInteger n) {
        Integer exponent = this.factors.get(n);
        if (exponent == null) {
            exponent = 0;
        }
        this.factors.put(n, exponent + 1);
    }
}

