/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.arithmetics.prime.primalitytest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tech.vineyard.arithmetics.prime.primalitytest.PrimalityTest;

public class PrimeIterator
implements Iterator<Integer>,
PrimalityTest {
    public final int size;
    private final boolean[] composite;
    private List<Integer> firstPrimes = new ArrayList<Integer>();
    private List<Integer> currentPrimes = new ArrayList<Integer>();
    private int last;
    private int current;
    private int start;
    private boolean isLastSegment;

    public PrimeIterator(int max) {
        if ((double)max > Math.sqrt(2.147483647E9)) {
            throw new RuntimeException("Sieve Segment size is too large");
        }
        this.size = max;
        this.composite = new boolean[this.size];
    }

    @Override
    public boolean hasNext() {
        if (this.current == 0) {
            this.sieve();
        } else if (this.current - this.start == this.currentPrimes.size() && !this.isLastSegment) {
            this.segmentedSieve();
        }
        return this.current - this.start < this.currentPrimes.size();
    }

    @Override
    public Integer next() {
        return this.currentPrimes.get(this.current++ - this.start);
    }

    @Override
    public boolean isPrime(int n) {
        return !this.hasPrimeDivisor(n);
    }

    private void sieve() {
        for (int i = 2; i < this.size; ++i) {
            if (this.composite[i]) continue;
            this.firstPrimes.add(i);
            for (int k = i * i; k < this.size; k += i) {
                this.composite[k] = true;
            }
        }
        this.last = this.size;
        this.start = 0;
        this.currentPrimes.addAll(this.firstPrimes);
    }

    private void segmentedSieve() {
        int p;
        int i;
        this.currentPrimes.clear();
        int min = this.last;
        int max = min + this.size;
        if (max > this.size * this.size - this.size) {
            this.isLastSegment = true;
        }
        for (i = 0; i < this.size; ++i) {
            this.composite[i] = false;
        }
        for (int j = 0; j < this.firstPrimes.size() && (p = this.firstPrimes.get(j).intValue()) * p < max; ++j) {
            int q = min / p;
            if (min % p != 0) {
                if (q * p > Integer.MAX_VALUE - p) continue;
                ++q;
            }
            q = Math.max(q, p);
            int kmax = Math.min(max, Integer.MAX_VALUE - p);
            for (int k = q * p; k < kmax; k += p) {
                this.composite[k - min] = true;
            }
        }
        for (i = 0; i < this.size; ++i) {
            if (this.composite[i] || min > Integer.MAX_VALUE - i) continue;
            this.currentPrimes.add(min + i);
        }
        this.last = max;
        this.start = this.current;
    }

    private boolean hasPrimeDivisor(int n) {
        int p;
        for (int i = 0; i < this.firstPrimes.size() && i >= (p = this.firstPrimes.get(i).intValue()) * p; ++i) {
            if (i % p != 0) continue;
            return true;
        }
        return false;
    }
}

