/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.arithmetics.prime.primalitytest;

import java.util.ArrayList;
import java.util.List;
import org.tech.vineyard.arithmetics.prime.primalitytest.PrimalityTest;

public class SievePrimalityTest
implements PrimalityTest {
    public static final int MAX = (int)Math.sqrt(2.147483647E9);
    private final boolean[] composite = new boolean[MAX];
    private final List<Integer> primes = new ArrayList<Integer>();

    public SievePrimalityTest() {
        this.sieve();
    }

    @Override
    public boolean isPrime(int i) {
        if (i < this.composite.length) {
            return !this.composite[i];
        }
        return !this.hasPrimeDivisor(i);
    }

    private void sieve() {
        for (int i = 2; i < MAX; ++i) {
            if (this.composite[i]) continue;
            this.primes.add(i);
            for (int k = i * i; k < this.composite.length; k += i) {
                this.composite[k] = true;
            }
        }
    }

    private boolean hasPrimeDivisor(int n) {
        int p;
        for (int i = 0; i < this.primes.size() && i >= (p = this.primes.get(i).intValue()) * p; ++i) {
            if (i % p != 0) continue;
            return true;
        }
        return false;
    }
}

