/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.arithmetics.prime.squareroot;

import java.util.Optional;
import java.util.stream.IntStream;
import org.tech.vineyard.arithmetics.ModularArithmetics;
import org.tech.vineyard.arithmetics.prime.squareroot.ModularSquareRoot;

public class TonelliShanksModularSquareRoot
implements ModularSquareRoot {
    int p;
    final ModularArithmetics modularArithmetics;
    int S;
    int Q;
    int c;

    public TonelliShanksModularSquareRoot(int p) {
        this.p = p;
        this.modularArithmetics = new ModularArithmetics(p);
        this.initVariables();
    }

    private void initVariables() {
        this.S = 0;
        this.Q = this.p - 1;
        while (this.Q % 2 == 0) {
            this.Q /= 2;
            ++this.S;
        }
        int z = this.quadraticNonResidue();
        this.c = this.modularExponent(z, this.Q);
    }

    private int quadraticNonResidue() {
        return IntStream.range(2, this.p).filter(this::isQuadraticNonResidue).findFirst().getAsInt();
    }

    private boolean isQuadraticNonResidue(int z) {
        return this.modularExponent(z, (this.p - 1) / 2) == this.p - 1;
    }

    @Override
    public Optional<Integer> get(int n) {
        if (n == 0) {
            return Optional.of(0);
        }
        if (this.isQuadraticNonResidue(n)) {
            return Optional.empty();
        }
        if (this.p % 4 == 3) {
            int r = this.modularExponent(n, (this.p + 1) / 4);
            return Optional.of(this.smallerRoot(r));
        }
        return this.tonelliShanks(n);
    }

    private Optional<Integer> tonelliShanks(int n) {
        int M = this.S;
        int t = this.modularExponent(n, this.Q);
        int R = this.modularExponent(n, (this.Q + 1) / 2);
        int c = this.c;
        while (t != 1) {
            int i = 0;
            int square = t;
            while (square != 1) {
                ++i;
                square = this.square(square);
            }
            int b = this.modularExponent(c, this.modularExponent(2, M - i - 1));
            M = i;
            c = this.square(b);
            t = this.multiply(t, c);
            R = this.multiply(R, b);
        }
        return Optional.of(this.smallerRoot(R));
    }

    private int smallerRoot(int R) {
        return Math.min(R, this.p - R);
    }

    private int modularExponent(int b, int e) {
        return this.modularArithmetics.exponent(b, e);
    }

    private int square(int a) {
        return this.modularArithmetics.square(a);
    }

    private int multiply(int a, int b) {
        return this.modularArithmetics.multiply(a, b);
    }
}

