/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.binarytree;

import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tech.vineyard.binarytree.BinaryTree;
import org.tech.vineyard.binarytree.BinaryTreeEnumeration;
import org.tech.vineyard.binarytree.BinaryTreeNode;
import org.tech.vineyard.binarytree.Node;
import org.tech.vineyard.binarytree.redblacktree.RedBlackTreeNode;

public class BinarySearchTree<T extends Comparable<T>>
implements BinaryTree<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(BinarySearchTree.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private Node<T> nil;
    private Node<T> root;

    public BinarySearchTree() {
        this.initTree();
    }

    private void initTree() {
        this.setNil(this.newNode(null));
        this.setRoot(this.getNil());
    }

    public void print(Node<T> node) {
        if (node.getLeft() != this.getNil()) {
            this.print(node.getLeft());
        }
        LOG.info(node.toString());
        if (node.getRight() != this.getNil()) {
            this.print(node.getRight());
        }
    }

    protected Node<T> newNode(T t) {
        return new BinaryTreeNode<T>(t);
    }

    @Override
    public Node<T> add(T t) {
        Node<T> z = this.newNode(t);
        this.addNode(this.getRoot(), z);
        return z;
    }

    protected void addNode(Node<T> x, Node<T> z) {
        z.setLeft(this.getNil());
        z.setRight(this.getNil());
        Node<T> y = this.getNil();
        while (x != this.getNil()) {
            y = x;
            if (z.compareTo(x) < 0) {
                x = x.getLeft();
                continue;
            }
            x = x.getRight();
        }
        z.setParent(y);
        if (y == this.getNil()) {
            this.setRoot(z);
        } else if (z.compareTo(y) < 0) {
            y.setLeft(z);
        } else {
            y.setRight(z);
        }
    }

    @Override
    public Node<T> search(T t) {
        Node<T> node = this.newNode(t);
        Node<Node<T>> current = this.getRoot();
        while (current != this.getNil()) {
            int c = current.compareTo(node);
            if (c == 0) {
                return current;
            }
            if (c < 0) {
                current = current.getRight();
                continue;
            }
            current = current.getLeft();
        }
        return null;
    }

    @Override
    public Node<T> delete(T t) {
        Node<T> node = this.search(t);
        if (node == null) {
            return null;
        }
        this.deleteNode(node);
        return node;
    }

    public Node<T> successor(Node<T> node) {
        if (node.getRight() != this.getNil()) {
            Node<T> leftMost = node.getRight();
            while (leftMost.getLeft() != this.getNil()) {
                leftMost = leftMost.getLeft();
            }
            return leftMost;
        }
        Node<T> child = node;
        for (Node<T> firstLeftParent = child.getParent(); firstLeftParent != this.getNil(); firstLeftParent = firstLeftParent.getParent()) {
            if (firstLeftParent.getLeft() != this.getNil() && firstLeftParent.getLeft().compareTo(child) == 0) {
                return firstLeftParent;
            }
            child = firstLeftParent;
        }
        return null;
    }

    public Node<T> predecessor(Node<T> node) {
        if (node.getLeft() != this.getNil()) {
            Node<T> rightMost = node.getLeft();
            while (rightMost.getRight() != this.getNil()) {
                rightMost = rightMost.getRight();
            }
            return rightMost;
        }
        Node<T> child = node;
        for (Node<T> firstRightParent = child.getParent(); firstRightParent != this.getNil(); firstRightParent = firstRightParent.getParent()) {
            if (firstRightParent.getRight() != this.getNil() && firstRightParent.getRight().compareTo(child) == 0) {
                return firstRightParent;
            }
            child = firstRightParent;
        }
        return null;
    }

    public Node<T> min() {
        if (this.getRoot() == this.getNil()) {
            return null;
        }
        return this.min(this.getRoot());
    }

    protected Node<T> min(Node<T> node) {
        while (node.getLeft() != this.getNil()) {
            node = node.getLeft();
        }
        return node;
    }

    public Node<T> max() {
        if (this.getRoot() == this.getNil()) {
            return null;
        }
        return this.max(this.getRoot());
    }

    private Node<T> max(Node<T> node) {
        while (node.getRight() != this.getNil()) {
            node = node.getRight();
        }
        return node;
    }

    public String graphvizGenerate() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph BinaryTree {");
        stringBuffer.append(NEW_LINE);
        if (this.getRoot() != this.getNil()) {
            this.graphvizGenerate(this.getRoot(), stringBuffer);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void graphvizGenerate(Node<T> node, StringBuffer stringBuffer) {
        stringBuffer.append(TAB);
        stringBuffer.append(node.getValue());
        if (node.getColor() == RedBlackTreeNode.Color.RED) {
            stringBuffer.append(" [color = red]");
        }
        stringBuffer.append(NEW_LINE);
        if (node.getLeft() != this.getNil()) {
            this.graphvizGenerate(node, node.getLeft(), stringBuffer);
        }
        if (node.getRight() != this.getNil()) {
            this.graphvizGenerate(node, node.getRight(), stringBuffer);
        }
    }

    private void graphvizGenerate(Node<T> parent, Node<T> child, StringBuffer stringBuffer) {
        stringBuffer.append(TAB);
        stringBuffer.append(parent.getValue());
        stringBuffer.append(" -> ");
        stringBuffer.append(child.getValue());
        stringBuffer.append("; ");
        stringBuffer.append(NEW_LINE);
        this.graphvizGenerate(child, stringBuffer);
    }

    public Enumeration<T> enumeration() {
        return new BinaryTreeEnumeration(this);
    }

    public void balance() {
        if (this.getRoot() == this.getNil()) {
            return;
        }
        this.balanceTree(this.getRoot());
    }

    private Integer balanceTree(Node<T> current) {
        Integer leftWeight = current.getLeft() == this.getNil() ? Integer.valueOf(0) : this.balanceTree(current.getLeft());
        Integer rightWeight = current.getRight() == this.getNil() ? Integer.valueOf(0) : this.balanceTree(current.getRight());
        while (leftWeight < rightWeight - 1) {
            Node<T> leftMost = this.replaceWithLeftMost(current);
            this.addNode(leftMost, current);
            leftWeight = leftWeight + 1;
            rightWeight = rightWeight - 1;
            current = leftMost;
        }
        while (rightWeight < leftWeight - 1) {
            Node<T> rightMost = this.replaceWithRightMost(current);
            this.addNode(rightMost, current);
            rightWeight = rightWeight + 1;
            leftWeight = leftWeight - 1;
            current = rightMost;
        }
        return leftWeight + rightWeight + 1;
    }

    protected Node<T> deleteNode(Node<T> current) {
        if (current.getLeft() != this.getNil()) {
            return this.replaceWithRightMost(current);
        }
        if (current.getRight() != this.getNil()) {
            return this.replaceWithLeftMost(current);
        }
        this.switchNode(current, this.getNil());
        return null;
    }

    private Node<T> replaceWithLeftMost(Node<T> current) {
        Node<T> leftMost = this.successor(current);
        if (leftMost == current.getRight()) {
            leftMost.setLeft(current.getLeft());
        } else {
            leftMost.getParent().setLeft(leftMost.getRight());
            if (leftMost.getRight() != this.getNil()) {
                leftMost.getRight().setParent(leftMost.getParent());
            }
            leftMost.setLeft(current.getLeft());
            if (leftMost.getLeft() != this.getNil()) {
                leftMost.getLeft().setParent(leftMost);
            }
            leftMost.setRight(current.getRight());
            current.getRight().setParent(leftMost);
        }
        this.switchNode(current, leftMost);
        if (leftMost.getParent() == this.getNil()) {
            this.setRoot(leftMost);
        }
        return leftMost;
    }

    private Node<T> replaceWithRightMost(Node<T> current) {
        Node<T> rightMost = this.predecessor(current);
        if (rightMost == current.getLeft()) {
            rightMost.setRight(current.getRight());
        } else {
            rightMost.getParent().setRight(rightMost.getLeft());
            if (rightMost.getLeft() != this.getNil()) {
                rightMost.getLeft().setParent(rightMost.getParent());
            }
            rightMost.setRight(current.getRight());
            if (rightMost.getRight() != this.getNil()) {
                rightMost.getRight().setParent(rightMost);
            }
            rightMost.setLeft(current.getLeft());
            current.getLeft().setParent(rightMost);
        }
        this.switchNode(current, rightMost);
        if (rightMost.getParent() == this.getNil()) {
            this.setRoot(rightMost);
        }
        return rightMost;
    }

    private void switchNode(Node<T> current, Node<T> newNode) {
        if (current.getParent() != this.getNil()) {
            if (current.getParent().getLeft() == current) {
                current.getParent().setLeft(newNode);
            } else if (current.getParent().getRight() == current) {
                current.getParent().setRight(newNode);
            }
        }
        if (newNode != this.getNil()) {
            newNode.setParent(current.getParent());
        }
        current.setLeft(this.getNil());
        current.setRight(this.getNil());
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public void setRoot(Node<T> node) {
        this.root = node;
    }

    public Node<T> getNil() {
        return this.nil;
    }

    public void setNil(Node<T> node) {
        this.nil = node;
    }
}

