/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.binarytree.binaryindexedtree;

import com.google.common.base.Preconditions;
import java.util.stream.IntStream;

public abstract class AbstractBinaryIndexedTree<T> {
    T[] count;
    int max;

    public AbstractBinaryIndexedTree(int max) {
        this.count = new Object[max + 1];
        IntStream.range(1, max + 1).forEach(i -> {
            this.count[i] = this.neutralElement();
        });
        this.max = max;
    }

    public void change(int i, T diff) {
        Preconditions.checkArgument((0 < i && i <= this.max ? 1 : 0) != 0);
        while (i <= this.max) {
            if (this.count[i] == null || diff == null) {
                throw new RuntimeException();
            }
            this.count[i] = this.add(this.count[i], diff);
            i += i & -i;
        }
    }

    public T get(int i) {
        Preconditions.checkArgument((0 < i && i <= this.max ? 1 : 0) != 0);
        T res = this.neutralElement();
        while (i > 0) {
            res = this.add(res, this.count[i]);
            i -= i & -i;
        }
        return res;
    }

    protected abstract T neutralElement();

    protected abstract T add(T var1, T var2);
}

