/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.binarytree.redblacktree;

import org.tech.vineyard.binarytree.BinarySearchTree;
import org.tech.vineyard.binarytree.Node;
import org.tech.vineyard.binarytree.redblacktree.RedBlackTreeNode;

public class RedBlackTree<T extends Comparable<T>>
extends BinarySearchTree<T> {
    @Override
    protected Node<T> newNode(T t) {
        return new RedBlackTreeNode<T>(t);
    }

    @Override
    public Node<T> add(T t) {
        Node<T> z = this.newNode(t);
        this.addNode(this.getRoot(), z);
        this.addFixup(z);
        return z;
    }

    @Override
    protected Node<T> deleteNode(Node<T> z) {
        Node<T> x;
        Node<T> y = z;
        RedBlackTreeNode.Color originalColor = y.getColor();
        if (z.getLeft() == this.getNil()) {
            x = z.getRight();
            this.transplant(z, z.getRight());
        } else if (z.getRight() == this.getNil()) {
            x = z.getLeft();
            this.transplant(z, z.getLeft());
        } else {
            y = this.min(z.getRight());
            originalColor = y.getColor();
            x = y.getRight();
            if (y.getParent() == z) {
                x.setParent(y);
            } else {
                this.transplant(y, y.getRight());
                y.setRight(z.getRight());
                y.getRight().setParent(y);
            }
            this.transplant(z, y);
            y.setLeft(z.getLeft());
            y.getLeft().setParent(y);
            y.setColor(z.getColor());
        }
        if (originalColor == RedBlackTreeNode.Color.BLACK) {
            this.deleteFixup(x);
        }
        return z;
    }

    private void addFixup(Node<T> z) {
        z.setColor(RedBlackTreeNode.Color.RED);
        while (z.getParent().getColor() == RedBlackTreeNode.Color.RED) {
            Node<T> y;
            if (z.getParent() == z.getParent().getParent().getLeft()) {
                y = z.getParent().getParent().getRight();
                if (y.getColor() == RedBlackTreeNode.Color.RED) {
                    z.getParent().setColor(RedBlackTreeNode.Color.BLACK);
                    y.setColor(RedBlackTreeNode.Color.BLACK);
                    z.getParent().getParent().setColor(RedBlackTreeNode.Color.RED);
                    z = z.getParent().getParent();
                    continue;
                }
                if (z == z.getParent().getRight()) {
                    z = z.getParent();
                    this.leftRotate(z);
                }
                z.getParent().setColor(RedBlackTreeNode.Color.BLACK);
                z.getParent().getParent().setColor(RedBlackTreeNode.Color.RED);
                this.rightRotate(z.getParent().getParent());
                continue;
            }
            y = z.getParent().getParent().getLeft();
            if (y.getColor() == RedBlackTreeNode.Color.RED) {
                z.getParent().setColor(RedBlackTreeNode.Color.BLACK);
                y.setColor(RedBlackTreeNode.Color.BLACK);
                z.getParent().getParent().setColor(RedBlackTreeNode.Color.RED);
                z = z.getParent().getParent();
                continue;
            }
            if (z == z.getParent().getLeft()) {
                z = z.getParent();
                this.rightRotate(z);
            }
            z.getParent().setColor(RedBlackTreeNode.Color.BLACK);
            z.getParent().getParent().setColor(RedBlackTreeNode.Color.RED);
            this.leftRotate(z.getParent().getParent());
        }
        this.getRoot().setColor(RedBlackTreeNode.Color.BLACK);
    }

    private void leftRotate(Node<T> x) {
        Node<T> y = x.getRight();
        x.setRight(y.getLeft());
        if (y.getLeft() != this.getNil()) {
            y.getLeft().setParent(x);
        }
        y.setParent(x.getParent());
        if (x.getParent() == this.getNil()) {
            this.setRoot(y);
        } else if (x == x.getParent().getLeft()) {
            x.getParent().setLeft(y);
        } else {
            x.getParent().setRight(y);
        }
        y.setLeft(x);
        x.setParent(y);
    }

    private void rightRotate(Node<T> x) {
        Node<T> y = x.getLeft();
        x.setLeft(y.getRight());
        if (y.getRight() != this.getNil()) {
            y.getRight().setParent(x);
        }
        y.setParent(x.getParent());
        if (x.getParent() == this.getNil()) {
            this.setRoot(y);
        } else if (x == x.getParent().getLeft()) {
            x.getParent().setLeft(y);
        } else {
            x.getParent().setRight(y);
        }
        y.setRight(x);
        x.setParent(y);
    }

    private void deleteFixup(Node<T> x) {
        while (x != this.getRoot() && x.getColor() == RedBlackTreeNode.Color.BLACK) {
            Node<T> w;
            if (x == x.getParent().getLeft()) {
                w = x.getParent().getRight();
                if (w.getColor() == RedBlackTreeNode.Color.RED) {
                    w.setColor(RedBlackTreeNode.Color.BLACK);
                    x.getParent().setColor(RedBlackTreeNode.Color.RED);
                    this.leftRotate(x.getParent());
                    w = x.getParent().getRight();
                }
                if (w.getLeft().getColor() == RedBlackTreeNode.Color.BLACK && w.getRight().getColor() == RedBlackTreeNode.Color.BLACK) {
                    w.setColor(RedBlackTreeNode.Color.RED);
                    x = x.getParent();
                    continue;
                }
                if (w.getRight().getColor() == RedBlackTreeNode.Color.BLACK) {
                    w.getLeft().setColor(RedBlackTreeNode.Color.BLACK);
                    w.setColor(RedBlackTreeNode.Color.RED);
                    this.rightRotate(w);
                    w = x.getParent().getRight();
                }
                w.setColor(x.getParent().getColor());
                x.getParent().setColor(RedBlackTreeNode.Color.BLACK);
                w.getRight().setColor(RedBlackTreeNode.Color.BLACK);
                this.leftRotate(x.getParent());
                x = this.getRoot();
                continue;
            }
            w = x.getParent().getLeft();
            if (w.getColor() == RedBlackTreeNode.Color.RED) {
                w.setColor(RedBlackTreeNode.Color.BLACK);
                x.getParent().setColor(RedBlackTreeNode.Color.RED);
                this.rightRotate(x.getParent());
                w = x.getParent().getLeft();
            }
            if (w.getLeft().getColor() == RedBlackTreeNode.Color.BLACK && w.getRight().getColor() == RedBlackTreeNode.Color.BLACK) {
                w.setColor(RedBlackTreeNode.Color.RED);
                x = x.getParent();
                continue;
            }
            if (w.getLeft().getColor() == RedBlackTreeNode.Color.BLACK) {
                w.getRight().setColor(RedBlackTreeNode.Color.BLACK);
                w.setColor(RedBlackTreeNode.Color.RED);
                this.leftRotate(w);
                w = x.getParent().getLeft();
            }
            w.setColor(x.getParent().getColor());
            x.getParent().setColor(RedBlackTreeNode.Color.BLACK);
            w.getLeft().setColor(RedBlackTreeNode.Color.BLACK);
            this.rightRotate(x.getParent());
            x = this.getRoot();
        }
        x.setColor(RedBlackTreeNode.Color.BLACK);
    }

    private void transplant(Node<T> u, Node<T> v) {
        if (u.getParent() == this.getNil()) {
            this.setRoot(v);
        } else if (u == u.getParent().getLeft()) {
            u.getParent().setLeft(v);
        } else {
            u.getParent().setRight(v);
        }
        v.setParent(u.getParent());
    }
}

