/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.binarytree.segmenttree;

import com.google.common.base.Preconditions;

public abstract class AbstractSegmentTree<T> {
    int n;
    T[] a;
    T[] nodes;
    boolean[] pending;
    T[] update;

    public AbstractSegmentTree(T[] a) {
        this.a = a;
        this.n = this.a.length - 1;
        this.build();
    }

    private void build() {
        int height = this.msb(this.n) + 1;
        int size = 1 << height;
        this.nodes = new Object[size];
        this.update = new Object[size];
        this.pending = new boolean[size];
        for (int i = 1; i < size; ++i) {
            this.update[i] = this.neutralElement();
        }
        this.build(1, 1, this.n);
    }

    private int msb(int n) {
        int k = 0;
        while (n > 0) {
            n >>= 1;
            ++k;
        }
        return k;
    }

    private void build(int i, int start, int end) {
        if (start >= end) {
            this.nodes[i] = this.a[start];
            return;
        }
        int mid = this.middle(start, end);
        int left = i << 1;
        int right = left + 1;
        this.build(left, start, mid);
        this.build(right, mid + 1, end);
        this.nodes[i] = this.query(this.nodes[left], this.nodes[right]);
    }

    private int middle(int start, int end) {
        return start + (end - start) / 2;
    }

    public T rangeQuery(int i, int j) {
        if (1 > i || i > j || j > this.n) {
            throw new RuntimeException();
        }
        Preconditions.checkArgument((1 <= i && i <= j && j <= this.n ? 1 : 0) != 0);
        return this.search(1, 1, this.n, i, j);
    }

    private T search(int i, int nodeStart, int nodeEnd, int start, int end) {
        if (this.pending[i]) {
            this.updatePending(i, nodeStart, nodeEnd, this.neutralElement());
        }
        if (nodeStart == start && nodeEnd == end) {
            return this.nodes[i];
        }
        int mid = this.middle(nodeStart, nodeEnd);
        int left = i << 1;
        int right = left + 1;
        if (start <= mid) {
            if (end <= mid) {
                T leftValue = this.search(left, nodeStart, mid, start, end);
                return leftValue;
            }
            T leftValue = this.search(left, nodeStart, mid, start, mid);
            T rightValue = this.search(right, mid + 1, nodeEnd, mid + 1, end);
            return this.query(leftValue, rightValue);
        }
        T rightValue = this.search(right, mid + 1, nodeEnd, start, end);
        return rightValue;
    }

    private void updatePending(int i, int nodeStart, int nodeEnd, T diff) {
        diff = this.query(diff, this.update[i]);
        this.pending[i] = false;
        this.update[i] = this.neutralElement();
        if (nodeStart >= nodeEnd) {
            this.a[nodeStart] = this.query(this.a[nodeStart], diff);
            this.nodes[i] = this.a[nodeStart];
            return;
        }
        int mid = this.middle(nodeStart, nodeEnd);
        int left = i << 1;
        int right = left + 1;
        if (this.pending[left] || !diff.equals(this.neutralElement())) {
            this.updatePending(left, nodeStart, mid, diff);
        }
        if (this.pending[right] || !diff.equals(this.neutralElement())) {
            this.updatePending(right, mid + 1, nodeEnd, diff);
        }
        this.nodes[i] = this.query(this.nodes[left], this.nodes[right]);
    }

    public void update(int pos, T v) {
        this.rangeQuery(pos, pos);
        this.update(1, 1, this.n, pos, v);
    }

    private void update(int i, int nodeStart, int nodeEnd, int pos, T v) {
        if (nodeStart == pos && nodeEnd == pos) {
            this.a[pos] = v;
            this.nodes[i] = this.a[pos];
            return;
        }
        int mid = this.middle(nodeStart, nodeEnd);
        int left = i << 1;
        int right = left + 1;
        if (pos <= mid) {
            this.update(left, nodeStart, mid, pos, v);
        } else {
            this.update(right, mid + 1, nodeEnd, pos, v);
        }
        this.nodes[i] = this.query(this.nodes[left], this.nodes[right]);
    }

    public void rangeUpdate(int start, int end, T diff) {
        this.rangeUpdate(1, 1, this.n, start, end, diff);
    }

    private void rangeUpdate(int i, int nodeStart, int nodeEnd, int start, int end, T diff) {
        this.pending[i] = true;
        if (nodeStart == start && nodeEnd == end) {
            this.update[i] = this.query(this.update[i], diff);
            return;
        }
        int mid = this.middle(nodeStart, nodeEnd);
        int left = i << 1;
        int right = left + 1;
        if (start <= mid) {
            if (end <= mid) {
                this.rangeUpdate(left, nodeStart, mid, start, end, diff);
            } else {
                this.rangeUpdate(left, nodeStart, mid, start, mid, diff);
                this.rangeUpdate(right, mid + 1, nodeEnd, mid + 1, end, diff);
            }
        } else {
            this.rangeUpdate(right, mid + 1, nodeEnd, start, end, diff);
        }
    }

    protected abstract T neutralElement();

    protected abstract T query(T var1, T var2);
}

