/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.binarytree.sparsetable;

import java.util.ArrayList;
import java.util.List;

public abstract class SparseTable<T> {
    List<List<T>> t;

    public SparseTable(T[] a) {
        this.buildTable(a);
    }

    private void buildTable(T[] a) {
        int n = a.length;
        this.t = new ArrayList<List<T>>(n);
        int bit = Integer.highestOneBit(n);
        int k = Integer.numberOfTrailingZeros(bit) + 1;
        for (int i = 0; i < n; ++i) {
            ArrayList<T> levels = new ArrayList<T>(k);
            levels.add(this.query(this.neutralElement(), a[i]));
            this.t.add(levels);
        }
        bit = 1;
        for (int j = 1; j < k; ++j) {
            int bit2 = bit << 1;
            int i = 0;
            while (i + bit2 <= n) {
                this.t.get(i).add(this.query(this.t.get(i).get(j - 1), this.t.get(i + bit).get(j - 1)));
                ++i;
            }
            bit = bit2;
        }
    }

    public T rangeQuery(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end >= this.t.size()) {
            end = this.t.size() - 1;
        }
        if (end < start) {
            return null;
        }
        T r = this.neutralElement();
        int bit = -1;
        while (bit != 0) {
            int delta = end - start;
            bit = Integer.highestOneBit(delta);
            int k = Integer.numberOfTrailingZeros(bit);
            if (bit == 0) {
                k = 0;
            }
            r = this.query(r, this.t.get(start).get(k));
            start += bit;
        }
        return r;
    }

    public abstract T neutralElement();

    public abstract T query(T var1, T var2);
}

