/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.disjointsets.linkedlist;

import java.util.ArrayList;
import java.util.List;
import org.tech.vineyard.disjointsets.DisjointSet;
import org.tech.vineyard.disjointsets.Node;
import org.tech.vineyard.disjointsets.linkedlist.LinkedListNode;

public class LinkedListDisjointSet<T>
implements DisjointSet<T> {
    private T value;
    private LinkedListNode<T> head;
    private LinkedListNode<T> tail;
    private int size;

    LinkedListDisjointSet(Node<T> n) {
        LinkedListNode node = (LinkedListNode)n;
        this.value = node.getValue();
        this.head = node;
        this.tail = node;
        this.size = 1;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    LinkedListNode<T> head() {
        return this.head;
    }

    LinkedListNode<T> tail() {
        return this.tail;
    }

    public void setTail(LinkedListNode<T> tail) {
        this.tail = tail;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public List<Node<T>> getNodes() {
        ArrayList<Node<T>> nodes = new ArrayList<Node<T>>(this.getSize());
        for (LinkedListNode<T> node = this.head(); node != null; node = node.getNext()) {
            nodes.add(node);
        }
        return nodes;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String toString() {
        return this.getNodes().toString();
    }
}

