/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.disjointsets.linkedlist;

import java.util.HashSet;
import java.util.Set;
import org.tech.vineyard.disjointsets.DisjointSet;
import org.tech.vineyard.disjointsets.DisjointSets;
import org.tech.vineyard.disjointsets.Node;
import org.tech.vineyard.disjointsets.linkedlist.LinkedListDisjointSet;
import org.tech.vineyard.disjointsets.linkedlist.LinkedListNode;

public class LinkedListDisjointSets<T>
implements DisjointSets<T> {
    private Set<DisjointSet<T>> sets = new HashSet<DisjointSet<T>>();

    @Override
    public Node<T> makeSet(T t) {
        LinkedListNode<T> node = new LinkedListNode<T>(t);
        this.sets.add(node.getRepresentative());
        return node;
    }

    @Override
    public DisjointSet<T> union(DisjointSet<T> s1, DisjointSet<T> s2) {
        LinkedListDisjointSet bigSet;
        LinkedListDisjointSet smallSet;
        if (s1 == s2) {
            return s1;
        }
        LinkedListDisjointSet set1 = (LinkedListDisjointSet)s1;
        LinkedListDisjointSet set2 = (LinkedListDisjointSet)s2;
        if (set1.getSize() <= set2.getSize()) {
            smallSet = set1;
            bigSet = set2;
        } else {
            smallSet = set2;
            bigSet = set1;
        }
        for (LinkedListNode node = smallSet.head(); node != null; node = node.getNext()) {
            node.setRepresentative(bigSet);
        }
        bigSet.tail().setNext(smallSet.head());
        bigSet.setTail(smallSet.tail());
        bigSet.setSize(bigSet.getSize() + smallSet.getSize());
        this.sets.remove(smallSet);
        return bigSet;
    }

    @Override
    public Set<DisjointSet<T>> getSets() {
        return this.sets;
    }
}

