/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.tech.vineyard.graph.Edge;

public class DotParser {
    private static final String GRAPH = "graph";
    private static final String OPEN_BRACE = "{";
    private static final String EDGE = "--";
    private static final String CLOSE_BRACE = "}";
    private static final Pattern WEIGHT = Pattern.compile("\\[label=(\\d+)\\]");
    private Scanner scanner;

    public DotParser(File dotFile) throws FileNotFoundException {
        this.scanner = new Scanner(dotFile);
    }

    public List<List<Edge>> parseAdjacency() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        String token = null;
        token = this.scanner.next();
        assert (token.equals(GRAPH));
        token = this.scanner.next();
        assert (token.equals(OPEN_BRACE));
        while (!(token = this.scanner.next()).equals(CLOSE_BRACE)) {
            edges.add(this.parseEdge(token));
        }
        return this.adjacency(edges);
    }

    private List<List<Edge>> adjacency(List<Edge> edges) {
        int n = (Integer)edges.stream().flatMap(edge -> Stream.of(edge.x, edge.y)).distinct().max(Integer::compareTo).get() + 1;
        ArrayList<List<Edge>> adjacency = new ArrayList<List<Edge>>();
        for (int i = 0; i < n; ++i) {
            adjacency.add(new ArrayList());
        }
        edges.stream().forEach(edge -> {
            ((List)adjacency.get(edge.x)).add(edge);
            ((List)adjacency.get(edge.y)).add(edge);
        });
        return adjacency;
    }

    private Edge parseEdge(String token) {
        String vertex1 = token;
        token = this.scanner.next();
        assert (token.equals(EDGE));
        String vertex2 = token = this.scanner.next();
        token = this.scanner.next();
        Matcher matcher = WEIGHT.matcher(token);
        matcher.find();
        String weight = matcher.group(1);
        int x = Integer.parseInt(vertex1);
        int y = Integer.parseInt(vertex2);
        int w = Integer.parseInt(weight);
        return new Edge(x, y, w);
    }
}

