/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph;

import java.io.File;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Scanner;

public class FloydAllPairShortestPath {
    int N;
    int M;
    int[][] adjacency;

    public static void main(String[] args) throws Exception {
        Scanner scanner = new Scanner(System.in);
        int N = scanner.nextInt();
        int M = scanner.nextInt();
        FloydAllPairShortestPath solution = new FloydAllPairShortestPath(N, M);
        for (int i = 0; i < M; ++i) {
            int x = scanner.nextInt();
            int y = scanner.nextInt();
            int r = scanner.nextInt();
            solution.addEdge(x, y, r);
        }
        int[][] distances = solution.shortestDistances();
        int Q = scanner.nextInt();
        for (int q = 0; q < Q; ++q) {
            int b;
            int a = scanner.nextInt();
            System.out.println(distances[a][b = scanner.nextInt()] == Integer.MAX_VALUE ? -1 : distances[a][b]);
        }
        scanner.close();
    }

    private int[][] shortestDistances() {
        int[][] distances = this.initDistances();
        for (int k = 1; k <= this.N; ++k) {
            for (int i = 1; i <= this.N; ++i) {
                for (int j = 1; j <= this.N; ++j) {
                    if (distances[i][k] == Integer.MAX_VALUE || distances[k][j] == Integer.MAX_VALUE || distances[i][k] + distances[k][j] >= distances[i][j]) continue;
                    distances[i][j] = distances[i][k] + distances[k][j];
                }
            }
        }
        return distances;
    }

    private int[][] initDistances() {
        int j;
        int i;
        int[][] distances = new int[this.N + 1][this.N + 1];
        for (i = 1; i <= this.N; ++i) {
            for (j = 1; j <= this.N; ++j) {
                distances[i][j] = Integer.MAX_VALUE;
            }
        }
        for (i = 1; i <= this.N; ++i) {
            distances[i][i] = 0;
        }
        for (i = 1; i <= this.N; ++i) {
            for (j = 1; j <= this.N; ++j) {
                if (this.adjacency[i][j] == 0) continue;
                distances[i][j] = this.adjacency[i][j];
            }
        }
        return distances;
    }

    private void print(int[][] distances) {
        for (int i = 1; i <= this.N; ++i) {
            for (int j = 1; j <= this.N; ++j) {
                System.out.print((distances[i][j] == Integer.MAX_VALUE ? -1 : distances[i][j]) + " ");
            }
            System.out.println();
        }
    }

    public FloydAllPairShortestPath(int N, int M) {
        this.N = N;
        this.M = M;
        this.adjacency = new int[N + 1][N + 1];
    }

    private void addEdge(int x, int y, int r) {
        this.adjacency[x][y] = r;
    }

    public void generateOutput() throws Exception {
        PrintWriter printWriter = new PrintWriter(new File("inputs/input"));
        int N = 400;
        int M = N * (N - 1) / 2;
        printWriter.print(N);
        printWriter.print(" ");
        printWriter.println(M);
        Random random = new Random();
        int W = 350;
        for (int i = 0; i < M; ++i) {
            printWriter.print(1 + random.nextInt(N));
            printWriter.print(" ");
            printWriter.print(1 + random.nextInt(N));
            printWriter.print(" ");
            printWriter.println(random.nextInt(W));
        }
        int Q = 100000;
        for (int q = 0; q < Q; ++q) {
            printWriter.print(1 + random.nextInt(N));
            printWriter.print(" ");
            printWriter.println(1 + random.nextInt(N));
        }
        printWriter.close();
    }
}

