/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SingleSourceUnweightedShortestPath {
    int N;
    int M;
    List<List<Integer>> adjacency;

    SingleSourceUnweightedShortestPath(int N, int M) {
        this.N = N;
        this.M = M;
        this.adjacency = new ArrayList<List<Integer>>(N + 1);
        for (int i = 0; i <= N; ++i) {
            this.adjacency.add(new LinkedList());
        }
    }

    public void addEdge(int x, int y) {
        this.adjacency.get(x).add(y);
        this.adjacency.get(y).add(x);
    }

    public List<Integer> shortestDistances(int S) {
        ArrayList<Integer> distances = new ArrayList<Integer>(this.N + 1);
        for (int k = 0; k <= this.N; ++k) {
            distances.add(null);
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        distances.set(S, 0);
        queue.offer(S);
        while (!queue.isEmpty()) {
            int n = (Integer)queue.poll();
            for (int k : this.adjacency.get(n)) {
                if (distances.get(k) != null) continue;
                distances.set(k, (Integer)distances.get(n) + 1);
                queue.offer(k);
            }
        }
        return distances;
    }
}

