/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.tech.vineyard.priorityqueue.Heap;

public class SingleSourceWeightedShortestPath {
    int N;
    int M;
    Node[] nodes;
    List<List<Edge>> adjacency;

    SingleSourceWeightedShortestPath(int N, int M) {
        this.N = N;
        this.M = M;
        this.nodes = new Node[N + 1];
        this.adjacency = new ArrayList<List<Edge>>(N + 1);
        this.adjacency.add(null);
        for (int k = 1; k <= N; ++k) {
            this.adjacency.add(new LinkedList());
            this.nodes[k] = new Node(k, Integer.MAX_VALUE);
        }
    }

    public void addEdge(int x, int y, int w) {
        this.adjacency.get(x).add(new Edge(this.nodes[x], this.nodes[y], w));
        this.adjacency.get(y).add(new Edge(this.nodes[y], this.nodes[x], w));
    }

    public List<Integer> shortestDistances(int S) {
        Heap queue = new Heap((Comparable[])this.nodes);
        this.decreaseKey(queue, S, 0);
        for (int k = 1; k <= this.N; ++k) {
            Node node = (Node)queue.pop();
            if (node.distance == Integer.MAX_VALUE) continue;
            for (Edge edge : this.adjacency.get(node.index)) {
                this.relax(queue, edge);
            }
        }
        ArrayList<Integer> distances = new ArrayList<Integer>(this.N + 1);
        distances.add(null);
        for (int k = 1; k <= this.N; ++k) {
            Node node = this.nodes[queue.get(k)];
            distances.add(node.distance);
        }
        return distances;
    }

    private void decreaseKey(Heap<Node> queue, int n, int newValue) {
        Node source = this.nodes[queue.get(n)];
        source.distance = 0;
        queue.keyDecreased(n);
    }

    private void relax(Heap<Node> queue, Edge edge) {
        int distance = edge.start.distance + edge.weight;
        if (distance < edge.end.distance) {
            this.decreaseKey(queue, edge.end.index, distance);
        }
    }

    class Node
    implements Comparable<Node> {
        int index;
        int distance;

        public Node(int index, int distance) {
            this.index = index;
            this.distance = distance;
        }

        @Override
        public int compareTo(Node node) {
            return this.distance - node.distance;
        }

        public String toString() {
            return String.valueOf(this.index);
        }
    }

    class Edge {
        Node start;
        Node end;
        int weight;

        public Edge(Node x, Node y, int w) {
            this.start = x;
            this.end = y;
            this.weight = w;
        }

        public String toString() {
            return this.start + " -> " + this.end + " (" + this.weight + ")";
        }
    }
}

