/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph.mst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tech.vineyard.graph.Edge;

public class KruskalMST {
    int N;
    List<Edge> edges = new ArrayList<Edge>();

    public KruskalMST(List<List<Edge>> adjacency) {
        this.N = adjacency.size();
        adjacency.stream().flatMap(Collection::stream).forEach(this.edges::add);
    }

    public long mstWeight() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.N);
        for (int i = 0; i < this.N; ++i) {
            nodes.add(new Node(i));
        }
        Collections.sort(this.edges);
        long weight = 0L;
        for (Edge edge : this.edges) {
            Node node2;
            Node node1 = ((Node)nodes.get(edge.x)).find();
            if (node1.equals(node2 = ((Node)nodes.get(edge.y)).find())) continue;
            node1.union(node2);
            weight += (long)edge.w;
        }
        return weight;
    }

    class Node {
        int id;
        Node parent;
        int rank;

        Node(int id) {
            this.id = id;
            this.parent = this;
            this.rank = 0;
        }

        Node find() {
            if (this.parent != this) {
                this.parent = this.parent.find();
            }
            return this.parent;
        }

        void union(Node node) {
            if (this.rank < node.rank) {
                this.parent = node;
            } else if (this.rank > node.rank) {
                node.parent = this;
            } else {
                node.parent = this;
                ++this.rank;
            }
        }

        public String toString() {
            return String.format("%d", this.id);
        }
    }
}

