/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph.mst;

import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.tech.vineyard.graph.Edge;

public class PrimMST {
    int N;
    List<List<Edge>> adjacency;

    public PrimMST(List<List<Edge>> adjacency) {
        this.adjacency = adjacency;
        this.N = adjacency.size();
    }

    public long mstWeight(int S) {
        long weight = 0L;
        boolean[] visited = new boolean[this.N];
        PriorityQueue<Edge> edges = new PriorityQueue<Edge>();
        this.visitNode(S, visited, edges);
        while (!edges.isEmpty()) {
            Edge edge = (Edge)edges.poll();
            if (visited[edge.y]) continue;
            this.visitNode(edge.y, visited, edges);
            weight += (long)edge.w;
        }
        return weight;
    }

    private void visitNode(int S, boolean[] visited, Queue<Edge> edges) {
        visited[S] = true;
        for (Edge edge : this.adjacency.get(S)) {
            if (visited[edge.y]) continue;
            edges.offer(edge);
        }
    }
}

