/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.tech.vineyard.graph.tree.SubTree;
import org.tech.vineyard.graph.tree.Tree;
import org.tech.vineyard.graph.tree.TreeNode;

public class SubtreeGenerator {
    private Tree tree;
    private boolean[] visited;

    public SubtreeGenerator(Tree tree) {
        this.tree = tree;
    }

    public List<Tree> subtrees() {
        ArrayList<Tree> subtrees = new ArrayList<Tree>();
        List<TreeNode> nodes = this.tree.getNodes();
        if (nodes.isEmpty()) {
            return subtrees;
        }
        this.visited = new boolean[nodes.size()];
        this.rootedSubtrees(0, subtrees);
        return subtrees;
    }

    private List<Tree> rootedSubtrees(int rootId, List<Tree> subtrees) {
        this.visited[rootId] = true;
        List<Integer> children = this.tree.getAdjacency().get(rootId).stream().filter(childId -> !this.visited[childId]).collect(Collectors.toList());
        List<List<Tree>> childSubtrees = children.stream().map(childId -> this.rootedSubtrees((int)childId, subtrees)).collect(Collectors.toList());
        ArrayList<Tree> rootedSubtrees = new ArrayList<Tree>();
        ArrayList<Tree> tuple = new ArrayList<Tree>();
        this.tuples(tuple, 0, childSubtrees, children, rootId, rootedSubtrees);
        subtrees.addAll(rootedSubtrees);
        return rootedSubtrees;
    }

    private void tuples(List<Tree> tuple, int i, List<List<Tree>> childSubtrees, List<Integer> children, int rootId, List<Tree> rootedSubtrees) {
        if (i == children.size()) {
            rootedSubtrees.add(this.rootedSubtree(rootId, children, tuple));
            return;
        }
        tuple.add(null);
        this.tuples(tuple, i + 1, childSubtrees, children, rootId, rootedSubtrees);
        tuple.remove(tuple.size() - 1);
        for (Tree childSubtree : childSubtrees.get(i)) {
            tuple.add(childSubtree);
            this.tuples(tuple, i + 1, childSubtrees, children, rootId, rootedSubtrees);
            tuple.remove(tuple.size() - 1);
        }
    }

    private Tree rootedSubtree(int rootId, List<Integer> children, List<Tree> tuple) {
        SubTree subTree = new SubTree();
        List<TreeNode> nodes = subTree.getNodes();
        List<List<Integer>> adjacency = subTree.getAdjacency();
        nodes.add(this.tree.getNodes().get(rootId));
        ArrayList<Integer> rootChildren = new ArrayList<Integer>();
        adjacency.add(rootChildren);
        for (int child = 0; child < children.size(); ++child) {
            Tree childSubtree = tuple.get(child);
            if (childSubtree == null) continue;
            rootChildren.add(children.get(child));
            nodes.addAll(childSubtree.getNodes());
            adjacency.addAll(childSubtree.getAdjacency());
        }
        subTree.setNodeIds();
        return subTree;
    }
}

