/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph.tree;

import java.util.ArrayList;
import java.util.List;
import org.tech.vineyard.graph.Edge;
import org.tech.vineyard.graph.tree.DefaultTreeNode;
import org.tech.vineyard.graph.tree.TreeNode;

public class Tree {
    protected List<TreeNode> nodes;
    protected List<List<Integer>> adjacency;
    protected boolean[] visited;
    protected int indent;

    public Tree() {
        this.nodes = new ArrayList<TreeNode>();
        this.adjacency = new ArrayList<List<Integer>>();
    }

    public Tree(int n, List<Edge> edges) {
        this();
        for (int i = 0; i < n; ++i) {
            this.nodes.add(new DefaultTreeNode(i));
            this.adjacency.add(new ArrayList());
        }
        for (Edge edge : edges) {
            this.adjacency.get(edge.x).add(edge.y);
            this.adjacency.get(edge.y).add(edge.x);
        }
    }

    public Tree(List<TreeNode> nodes, List<List<Integer>> adjacency) {
        this.nodes = nodes;
        this.adjacency = adjacency;
    }

    public List<TreeNode> getNodes() {
        return this.nodes;
    }

    public List<List<Integer>> getAdjacency() {
        return this.adjacency;
    }

    public void print() {
        if (this.nodes.isEmpty()) {
            return;
        }
        this.indent = 0;
        this.visited = new boolean[this.nodes.size()];
        this.printNode(0);
    }

    private void printNode(int nodeIndex) {
        TreeNode node = this.nodes.get(nodeIndex);
        this.visited[nodeIndex] = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indent; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(node);
        System.out.println(stringBuffer);
        ++this.indent;
        for (int neighbor : this.adjacency.get(nodeIndex)) {
            int neighborId = this.getNodeId(neighbor);
            if (this.visited[neighborId]) continue;
            this.printNode(neighborId);
        }
        --this.indent;
    }

    protected int getNodeId(int nodeId) {
        return nodeId;
    }
}

