/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph.tree.lca;

import java.util.ArrayDeque;
import org.tech.vineyard.graph.tree.Tree;
import org.tech.vineyard.graph.tree.TreeNode;
import org.tech.vineyard.graph.tree.lca.LowestCommonAncestor;

public class SparseTableLowestCommonAncestor
implements LowestCommonAncestor {
    boolean[] visited;
    int[] parent;
    int[] level;
    int[][] ancestors;
    int maxLog;
    Tree tree;
    int N;

    public SparseTableLowestCommonAncestor(Tree tree) {
        this.tree = tree;
        this.N = tree.getNodes().size();
        this.visited = new boolean[this.N];
        this.parent = new int[this.N];
        this.level = new int[this.N];
        this.dfs();
        this.setAncestorSparseTable();
    }

    private void dfs() {
        int root = 0;
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        stack.add(root);
        this.visited[root] = true;
        while (!stack.isEmpty()) {
            int top = (Integer)stack.remove();
            for (int neighbor : this.tree.getAdjacency().get(top)) {
                if (this.visited[neighbor]) continue;
                stack.add(neighbor);
                this.visited[neighbor] = true;
                this.parent[neighbor] = top;
                this.level[neighbor] = this.level[top] + 1;
            }
        }
    }

    @Override
    public TreeNode lca(TreeNode left, TreeNode right) {
        return this.tree.getNodes().get(this.lca(left.getId(), right.getId()));
    }

    private void setAncestorSparseTable() {
        this.maxLog = this.log2(this.N - 1);
        this.ancestors = new int[this.N][this.maxLog];
        for (int i = 0; i < this.N; ++i) {
            this.ancestors[i][0] = this.parent[i];
        }
        for (int j = 1; j < this.maxLog; ++j) {
            for (int i = 0; i < this.N; ++i) {
                if (this.ancestors[i][j - 1] == 0) continue;
                this.ancestors[i][j] = this.ancestors[this.ancestors[i][j - 1]][j - 1];
            }
        }
    }

    private int log2(int n) {
        int k = 0;
        while (n > 0) {
            ++k;
            n >>= 1;
        }
        return k;
    }

    int lca(int u, int v) {
        int j;
        if (this.level[u] > this.level[v]) {
            return this.lca(v, u);
        }
        for (int dist = this.level[v] - this.level[u]; dist > 0; dist -= 1 << j) {
            j = this.log2(dist) - 1;
            v = this.ancestors[v][j];
        }
        if (u == v) {
            return u;
        }
        for (j = this.maxLog - 1; j >= 0; --j) {
            if (this.ancestors[u][j] == 0 || this.ancestors[u][j] == this.ancestors[v][j]) continue;
            u = this.ancestors[u][j];
            v = this.ancestors[v][j];
        }
        return this.parent[u];
    }
}

