/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.graph.tree.traversal;

import java.util.LinkedList;
import java.util.List;
import org.tech.vineyard.graph.tree.traversal.Color;
import org.tech.vineyard.graph.tree.traversal.NodeVisitor;
import org.tech.vineyard.graph.tree.traversal.Traversal;

public abstract class AbstractDFSTraversal
implements Traversal {
    @Override
    public void traverse(NodeVisitor nodeVisitor) {
        int i;
        int N = this.getNodeCount();
        Color[] color = new Color[N];
        for (int i2 = 0; i2 < N; ++i2) {
            color[i2] = Color.WHITE;
        }
        int[] parents = new int[N];
        for (i = 0; i < N; ++i) {
            parents[i] = -1;
        }
        for (i = 0; i < N; ++i) {
            if (color[i] != Color.WHITE) continue;
            this.traverse(i, nodeVisitor, color, parents);
        }
    }

    protected abstract int getNodeCount();

    protected abstract List<Integer> getAdjacency(int var1);

    private void traverse(int root, NodeVisitor nodeVisitor, Color[] color, int[] parents) {
        LinkedList<Integer> deque = new LinkedList<Integer>();
        deque.addLast(root);
        while (!deque.isEmpty()) {
            int current = (Integer)deque.getLast();
            List<Integer> c = this.getAdjacency(current);
            if (color[current] == Color.WHITE) {
                color[current] = Color.GRAY;
                c.stream().filter(child -> color[child] == Color.WHITE).peek(child -> {
                    parents[child.intValue()] = current;
                }).forEach(deque::addLast);
                continue;
            }
            nodeVisitor.visit(current, parents[current], c);
            color[current] = Color.BLACK;
            deque.removeLast();
        }
    }
}

