/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.algebra;

import org.tech.vineyard.linear.algebra.Matrix;
import org.tech.vineyard.linear.algebra.NegativeEigenvalueException;
import org.tech.vineyard.linear.algebra.Vector;

public class CholeskyDecomposition {
    private Matrix M;
    private Matrix L;

    public CholeskyDecomposition(Matrix M) throws NegativeEigenvalueException {
        this.M = M;
        this.L = this.choleskyDecomposition();
    }

    public Matrix L() {
        return this.L;
    }

    public Matrix choleskyDecomposition() throws NegativeEigenvalueException {
        Matrix A = this.M;
        Matrix L = Matrix.identity(A.n);
        for (int i = 0; i < A.n; ++i) {
            this.choleskyUpdate(A, L, i);
        }
        return L;
    }

    private void choleskyUpdate(Matrix A, Matrix L, int step) throws NegativeEigenvalueException {
        double sqrt;
        if (A.M[step][step] < 0.0) {
            throw new NegativeEigenvalueException();
        }
        L.M[step][step] = sqrt = Math.sqrt(A.M[step][step]);
        double[] b = new double[A.n - step - 1];
        for (int i = step + 1; i < A.n; ++i) {
            b[i - step - 1] = A.M[i][step];
            L.M[i][step] = A.M[i][step] / sqrt;
            A.M[i][step] = 0.0;
            A.M[step][i] = 0.0;
        }
        Matrix outerProduct = new Vector(b).outerProduct().multiply(1.0 / A.M[step][step]);
        A.diff(outerProduct, step + 1, step + 1);
        A.M[step][step] = 1.0;
    }
}

