/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.algebra;

import java.util.Arrays;
import org.tech.vineyard.linear.algebra.Matrix;

public class IntVector {
    int size;
    public int[] v;
    Integer mean = null;
    Integer standardVariation = null;
    Integer variance = null;

    public IntVector(int[] v) {
        this.init(v);
    }

    public IntVector(int size) {
        this.init(new int[size]);
    }

    private void init(int[] v) {
        this.v = v;
        this.size = v.length;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return Arrays.toString(this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntVector)) {
            return false;
        }
        IntVector other = (IntVector)object;
        return Arrays.equals(this.v, other.v);
    }

    public static Matrix vanDerMonde(IntVector v, int n) {
        int[] x = v.v;
        int[][] d = new int[x.length][n + 1];
        for (int i = 0; i < x.length; ++i) {
            d[i] = IntVector.vanDerMondeRow(n, x[i]);
        }
        return new Matrix(d);
    }

    public static int[] vanDerMondeRow(int n, int xi) {
        int[] row = new int[n + 1];
        int pow = 1;
        for (int j = 0; j <= n; ++j) {
            row[j] = pow;
            pow = IntVector.multiply(pow, xi);
        }
        return row;
    }

    private static int add(int a, int b) {
        return a + b;
    }

    private static int substract(int a, int b) {
        return a - b;
    }

    private static int multiply(int a, int b) {
        return a * b;
    }

    private static int divide(int a, int b) {
        return IntVector.multiply(a, IntVector.inverse(b));
    }

    private static int inverse(int a) {
        return 1 / a;
    }

    private static int sqrt(int a) {
        return (int)Math.sqrt(a);
    }

    public int dotProduct(IntVector vector) {
        int d = 0;
        int[] row = vector.v;
        for (int k = 0; k < row.length; ++k) {
            d = IntVector.add(d, IntVector.multiply(this.v[k], row[k]));
        }
        return d;
    }

    private double[] toDouble(int[] y) {
        double[] d = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            d[i] = y[i];
        }
        return d;
    }

    public Matrix outerProduct() {
        int[][] d = new int[this.v.length][this.v.length];
        for (int i = 0; i < this.v.length; ++i) {
            for (int j = 0; j < i; ++j) {
                d[i][j] = IntVector.multiply(this.v[i], this.v[j]);
                d[j][i] = d[i][j];
            }
            d[i][i] = IntVector.multiply(this.v[i], this.v[i]);
        }
        return new Matrix(d);
    }

    public static IntVector range(int size) {
        int[] d = new int[size];
        for (int i = 0; i < size; ++i) {
            d[i] = i;
        }
        return new IntVector(d);
    }

    public IntVector multiply(int d) {
        return this.apply(t -> IntVector.multiply(t, d));
    }

    public IntVector divide(int d) {
        return this.apply(t -> IntVector.divide(t, d));
    }

    public IntVector add(IntVector u) {
        return this.combine(u, IntVector::add);
    }

    public IntVector minus(IntVector u) {
        return this.combine(u, IntVector::substract);
    }

    public IntVector multiply(IntVector u) {
        return this.combine(u, IntVector::multiply);
    }

    public void multiply(int[] u) {
        for (int i = 0; i < this.size; ++i) {
            u[i] = IntVector.multiply(u[i], this.v[i]);
        }
    }

    public IntVector apply(Transform transform) {
        int[] d = new int[this.v.length];
        for (int i = 0; i < this.v.length; ++i) {
            d[i] = transform.transform(this.v[i]);
        }
        return new IntVector(d);
    }

    public IntVector combine(IntVector u, Combine c) {
        int[] d = new int[this.v.length];
        for (int i = 0; i < this.v.length; ++i) {
            d[i] = c.combine(this.v[i], u.v[i]);
        }
        return new IntVector(d);
    }

    public int mean() {
        if (this.mean == null) {
            this.mean = this.computeMean();
        }
        return this.mean;
    }

    private int computeMean() {
        int sum = 0;
        for (int i = 0; i < this.size; ++i) {
            sum = IntVector.add(sum, this.v[i]);
        }
        return sum / this.size;
    }

    public int standardVariation() {
        if (this.standardVariation == null) {
            this.standardVariation = this.computeStandardVariation();
        }
        return this.standardVariation;
    }

    private int computeStandardVariation() {
        return IntVector.sqrt(this.variance());
    }

    public int variance() {
        if (this.variance == null) {
            this.variance = this.computeVariance();
        }
        return this.variance;
    }

    private int computeVariance() {
        int mu = this.mean();
        return this.apply(t -> (t - mu) * (t - mu)).mean();
    }

    public IntVector scale() {
        return this.apply(this.scaleTransform());
    }

    private Transform scaleTransform() {
        int mu = this.mean();
        int sigma = this.standardVariation();
        return t -> IntVector.divide(IntVector.substract(t, mu), sigma);
    }

    public int scale(int x0) {
        return this.scaleTransform().transform(x0);
    }

    public int unscale(int x0) {
        return this.unscaleTransform().transform(x0);
    }

    private Transform unscaleTransform() {
        int mu = this.mean();
        int sigma = this.standardVariation();
        return t -> IntVector.add(IntVector.multiply(sigma, t), mu);
    }

    public int get(int i) {
        return this.v[i];
    }

    public void set(int i, int value) {
        this.v[i] = value;
    }

    public static interface Transform {
        public int transform(int var1);
    }

    public static interface Combine {
        public int combine(int var1, int var2);
    }
}

