/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.algebra;

import org.tech.vineyard.linear.algebra.Matrix;
import org.tech.vineyard.linear.algebra.Vector;

public class QRDecomposition {
    private Matrix A;
    private Matrix Q;

    public QRDecomposition(Matrix A) {
        this.A = A;
        this.Q = Matrix.identity(this.A.m);
        for (int j = 0; j < 2; ++j) {
            Matrix q = this.houseHolderReflection(A, j);
            q.leftMultiply(A, j);
            q.transpose().rightMultiply(this.Q, j);
            for (int i = j + 1; i < this.A.m; ++i) {
                A.M[i][j] = 0.0;
            }
        }
    }

    public Matrix Q() {
        return this.Q;
    }

    public Matrix R() {
        return this.A;
    }

    private Matrix houseHolderReflection(Matrix A, int j) {
        int size = this.A.m - j;
        double[] u = new double[size];
        for (int i = j; i < this.A.m; ++i) {
            u[i - j] = A.M[i][j];
        }
        Vector U = new Vector(u);
        u[0] = u[0] - U.euclideanNorm();
        return U.outerProduct().multiply(2.0 / U.dotProduct()).minus(Matrix.identity(size));
    }
}

