/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.algebra;

import java.util.Arrays;
import org.tech.vineyard.linear.algebra.Matrix;

public class Vector {
    private static final double PRECISION = 1.0E-4;
    int size;
    public double[] v;
    Double mean = null;
    Double standardVariation = null;
    Double variance = null;

    public Vector(double[] v) {
        this.init(v);
    }

    public Vector(int[] v) {
        this.init(this.toDouble(v));
    }

    public Vector(int size) {
        this.init(new double[size]);
    }

    private void init(double[] v) {
        this.v = v;
        this.size = v.length;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return Arrays.toString(this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)object;
        if (this.size != other.size) {
            return false;
        }
        return Vector.doubleArrayEquals(this.v, other.v);
    }

    public static boolean doubleArrayEquals(double[] d1, double[] d2) {
        for (int i = 0; i < d1.length; ++i) {
            if (Vector.doubleEquals(d1[i], d2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean doubleEquals(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-4;
    }

    public static Matrix vanDerMonde(Vector v, int n) {
        double[] x = v.v;
        double[][] d = new double[x.length][n + 1];
        for (int i = 0; i < x.length; ++i) {
            d[i] = Vector.vanDerMondeRow(n, x[i]);
        }
        return new Matrix(d);
    }

    public static double[] vanDerMondeRow(int n, double xi) {
        double[] row = new double[n + 1];
        double pow = 1.0;
        for (int j = 0; j <= n; ++j) {
            row[j] = pow;
            pow *= xi;
        }
        return row;
    }

    public double dotProduct(Vector vector) {
        double d = 0.0;
        double[] row = vector.v;
        for (int k = 0; k < row.length; ++k) {
            d += this.v[k] * row[k];
        }
        return d;
    }

    private double[] toDouble(int[] y) {
        double[] d = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            d[i] = y[i];
        }
        return d;
    }

    public int[] toInt() {
        int[] i = new int[this.size];
        for (int j = 0; j < this.size; ++j) {
            i[j] = (int)Math.round(this.v[j]);
        }
        return i;
    }

    public Matrix outerProduct() {
        double[][] d = new double[this.v.length][this.v.length];
        for (int i = 0; i < this.v.length; ++i) {
            for (int j = 0; j < i; ++j) {
                d[i][j] = this.v[i] * this.v[j];
                d[j][i] = d[i][j];
            }
            d[i][i] = this.v[i] * this.v[i];
        }
        return new Matrix(d);
    }

    public static Vector range(int size) {
        double[] d = new double[size];
        for (int i = 0; i < size; ++i) {
            d[i] = i;
        }
        return new Vector(d);
    }

    public Vector multiply(double d) {
        return this.apply(t -> t * d);
    }

    public Vector divide(double d) {
        return this.apply(t -> t / d);
    }

    public Vector add(Vector u) {
        return this.combine(u, (d1, d2) -> d1 + d2);
    }

    public Vector minus(Vector u) {
        return this.combine(u, (d1, d2) -> d1 - d2);
    }

    public Vector multiply(Vector u) {
        return this.combine(u, (d1, d2) -> d1 * d2);
    }

    public void multiply(double[] u) {
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            u[n] = u[n] * this.v[i];
        }
    }

    public Vector apply(Transform transform) {
        double[] d = new double[this.v.length];
        for (int i = 0; i < this.v.length; ++i) {
            d[i] = transform.transform(this.v[i]);
        }
        return new Vector(d);
    }

    public Vector combine(Vector u, Combine c) {
        double[] d = new double[this.v.length];
        for (int i = 0; i < this.v.length; ++i) {
            d[i] = c.combine(this.v[i], u.v[i]);
        }
        return new Vector(d);
    }

    public double mean() {
        if (this.mean == null) {
            this.mean = this.computeMean();
        }
        return this.mean;
    }

    private Double computeMean() {
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sum += this.v[i];
        }
        return sum / (double)this.size;
    }

    public double standardVariation() {
        if (this.standardVariation == null) {
            this.standardVariation = this.computeStandardVariation();
        }
        return this.standardVariation;
    }

    private Double computeStandardVariation() {
        return Math.sqrt(this.variance());
    }

    public double variance() {
        if (this.variance == null) {
            this.variance = this.computeVariance();
        }
        return this.variance;
    }

    private double computeVariance() {
        double mu = this.mean();
        return this.apply(t -> (t - mu) * (t - mu)).mean();
    }

    public Vector scale() {
        return this.apply(this.scaleTransform());
    }

    private Transform scaleTransform() {
        double mu = this.mean();
        double sigma = this.standardVariation();
        return t -> (t - mu) / sigma;
    }

    public double scale(double x0) {
        return this.scaleTransform().transform(x0);
    }

    public double unscale(double x0) {
        return this.unscaleTransform().transform(x0);
    }

    private Transform unscaleTransform() {
        double mu = this.mean();
        double sigma = this.standardVariation();
        return t -> sigma * t + mu;
    }

    public double get(int i) {
        return this.v[i];
    }

    public double euclideanNorm() {
        return Math.sqrt(this.dotProduct());
    }

    public double dotProduct() {
        return this.dotProduct(this);
    }

    public static interface Transform {
        public double transform(double var1);
    }

    public static interface Combine {
        public double combine(double var1, double var3);
    }
}

