/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.algebra.interpolation;

import org.tech.vineyard.linear.algebra.Matrix;
import org.tech.vineyard.linear.algebra.Vector;
import org.tech.vineyard.linear.algebra.interpolation.PolyFit;

public class CubicSplineInterpolation
implements PolyFit {
    double[] x;
    double[] y;
    int size;
    double[] b;
    double[] c;
    double[] d;

    public CubicSplineInterpolation(double[] x, double[] y) {
        this.x = x;
        this.y = y;
        this.size = x.length;
        this.cubicSplineSolve();
    }

    @Override
    public double fit(double x0) {
        int j = this.windowIndex(x0);
        return this.f(j, x0);
    }

    private void cubicSplineSolve() {
        int i;
        Vector z = this.tridiagonalSolve();
        this.c = z.v;
        this.d = new double[this.size - 1];
        this.d[0] = 0.0;
        this.d[this.size - 2] = 0.0;
        for (i = 1; i < this.size - 2; ++i) {
            this.d[i] = (this.c[i + 1] - this.c[i]) / (this.x[i + 1] - this.x[i]);
        }
        this.b = new double[this.size - 1];
        for (i = 0; i < this.size - 1; ++i) {
            double delta = this.x[i + 1] - this.x[i];
            this.b[i] = (this.y[i + 1] - this.y[i]) / delta - this.c[i] / 2.0 * delta - this.d[i] / 6.0 * delta * delta;
        }
    }

    private int windowIndex(double x0) {
        int s;
        for (s = 0; s < this.size && x0 >= this.x[s]; ++s) {
        }
        if (s == 0) {
            return 0;
        }
        if (s == this.size) {
            return this.size - 2;
        }
        return s - 1;
    }

    private double f(int j, double x0) {
        double delta = x0 - this.x[j];
        return this.y[j] + this.b[j] * delta + this.c[j] / 2.0 * delta * delta + this.d[j] / 6.0 * delta * delta * delta;
    }

    private Vector tridiagonalSolve() {
        double[][] a = new double[this.size - 1][this.size - 1];
        a[0][0] = 1.0;
        a[0][1] = -1.0;
        for (int i = 1; i < this.size - 2; ++i) {
            a[i][i - 1] = (this.x[i - 1] - this.x[i]) / 6.0;
            a[i][i] = (this.x[i - 1] - this.x[i + 1]) / 3.0;
            a[i][i + 1] = (this.x[i] - this.x[i + 1]) / 6.0;
        }
        a[this.size - 2][this.size - 3] = (this.x[this.size - 3] - this.x[this.size - 2]) / 6.0;
        a[this.size - 2][this.size - 2] = this.x[this.size - 3] / 3.0 + this.x[this.size - 2] / 6.0 + this.x[this.size - 1] / 3.0;
        double[] t = new double[this.size - 1];
        t[0] = 0.0;
        for (int i = 1; i < this.size - 1; ++i) {
            t[i] = (this.y[i] - this.y[i - 1]) / (this.x[i] - this.x[i - 1]) - (this.y[i + 1] - this.y[i]) / (this.x[i + 1] - this.x[i]);
        }
        Matrix tridiagonal = new Matrix(a);
        return tridiagonal.tridiagonalSolve(new Vector(t));
    }
}

