/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.algebra.interpolation;

import org.tech.vineyard.linear.algebra.interpolation.PolyFit;

public class LagrangeInterpolation
implements PolyFit {
    double[] x;
    double[] y;

    public LagrangeInterpolation(double[] x, double[] y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double fit(double x0) {
        double y0 = 0.0;
        for (int k = 0; k < this.x.length; ++k) {
            y0 += this.lambda(x0, k) * this.y[k];
        }
        return y0;
    }

    private double lambda(double x0, int k) {
        double l = 1.0;
        for (int i = 0; i < this.x.length; ++i) {
            if (i == k) continue;
            l *= (x0 - this.x[i]) / (this.x[k] - this.x[i]);
        }
        return l;
    }
}

