/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.algebra.interpolation;

import org.tech.vineyard.linear.algebra.Vector;
import org.tech.vineyard.linear.algebra.fitting.LinearRegression;
import org.tech.vineyard.linear.algebra.interpolation.LagrangeInterpolation;
import org.tech.vineyard.linear.algebra.interpolation.PolyFit;

public class WindowSelector {
    double[] x;
    double[] y;
    double[] sx;
    double[] sy;
    int n;
    double x0;

    public WindowSelector(double[] x, double[] y, int n) {
        this.x = x;
        this.y = y;
        this.n = n;
        if (this.x.length < this.n) {
            this.n = this.x.length;
        }
        this.sx = new double[this.n];
        this.sy = new double[this.n];
    }

    public void setX0(double x0) {
        this.x0 = x0;
        this.setWindow();
    }

    public void setWindow() {
        int s = this.windowStart();
        int e = s + this.n - 1;
        for (int i = s; i <= e; ++i) {
            this.sx[i - s] = this.x[i];
            this.sy[i - s] = this.y[i];
        }
    }

    private int windowStart() {
        int s;
        for (s = 0; s < this.x.length && this.x0 >= this.x[s]; ++s) {
        }
        if ((s -= this.n / 2) < 0) {
            s = 0;
        } else if (s + this.n - 1 >= this.x.length) {
            s = this.x.length - this.n;
        }
        return s;
    }

    public PolyFit lagrangeInterpolation() {
        return new LagrangeInterpolation(this.sx, this.sy);
    }

    public PolyFit linearLeastSquaresInterpolation() throws Exception {
        return new LinearRegression(this.n - 1, new Vector(this.sx), new Vector(this.sy));
    }
}

