/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.programming;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tech.vineyard.linear.programming.Constraint;
import org.tech.vineyard.linear.programming.Objective;
import org.tech.vineyard.linear.programming.Simplex;

public class BranchAndBound {
    private static final Logger LOG = LoggerFactory.getLogger(BranchAndBound.class);
    private final Simplex root;
    private Objective objective;
    private double objectiveValue;
    private double[] solution;
    private int intObjectiveValue;
    private int[] intSolution;

    public BranchAndBound(Simplex root) {
        this.root = root;
        this.objective = root.objective();
        this.objectiveValue = this.objective == Objective.MAX ? Double.MIN_VALUE : Double.MAX_VALUE;
        this.traverse(root, 0);
        if (this.solution != null) {
            this.setSolution();
            LOG.info("Optimal solution {} {}", (Object)this.objectiveValue, (Object)Arrays.toString(this.intSolution));
        }
    }

    private void setSolution() {
        this.intObjectiveValue = (int)this.objectiveValue;
        this.intSolution = new int[this.solution.length];
        for (int i = 0; i < this.solution.length; ++i) {
            this.intSolution[i] = (int)this.solution[i];
        }
    }

    public int objectiveValue() {
        return this.intObjectiveValue;
    }

    public int[] solution() {
        return this.intSolution;
    }

    private void traverse(Simplex current, int i) {
        double[] solution = current.solution();
        if (i == solution.length) {
            if (this.objective == Objective.MAX && current.objectiveValue() > this.objectiveValue || this.objective == Objective.MIN && current.objectiveValue() < this.objectiveValue) {
                this.objectiveValue = current.objectiveValue();
                this.solution = current.solution();
            }
            return;
        }
        double x = solution[i];
        if (this.isInteger(x)) {
            this.traverse(current, i + 1);
            return;
        }
        int b = (int)Math.floor(x);
        this.branch(current, i, b, Constraint.LOWER);
        this.branch(current, i, b + 1, Constraint.GREATER);
    }

    private void branch(Simplex current, int i, int b, Constraint constraint) {
        if (b == 0) {
            return;
        }
        Simplex child = new Simplex(current);
        try {
            child.addIntegerConstraint(i, b, constraint);
        }
        catch (RuntimeException re) {
            return;
        }
        LOG.info("Solution {} {}", (Object)child.objectiveValue(), (Object)Arrays.toString(child.solution()));
        if (this.objective == Objective.MAX && child.objectiveValue() <= this.objectiveValue || this.objective == Objective.MIN && child.objectiveValue() >= this.objectiveValue) {
            return;
        }
        this.traverse(child, 0);
    }

    private boolean isInteger(double x) {
        return Math.floor(x) == x;
    }

    private boolean isIntegerSolution(double[] solution) {
        return Arrays.stream(solution).allMatch(this::isInteger);
    }
}

