/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.linear.programming;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tech.vineyard.linear.programming.Constraint;
import org.tech.vineyard.linear.programming.Objective;

public class Simplex {
    private static final Logger LOG = LoggerFactory.getLogger(Simplex.class);
    private final double[] c;
    private final double[][] A;
    private final double[] b;
    private final Constraint[] constraints;
    private final Objective objective;
    int n;
    int m;
    private double[][] t;
    private int[] originalVariables;
    private int[] slackVariables;
    private int[] artificialVariables;
    private int[] basicVariables;
    private int objectiveRow;
    private int lastColumn;
    private double[] basicFeasibleSolution;

    public Simplex(double[] c, double[][] A, double[] b, Constraint[] constraints, Objective objective) {
        this.c = c;
        this.A = A;
        this.b = b;
        this.constraints = constraints;
        this.objective = objective;
        this.runFullTableauMethod();
    }

    public Simplex(Simplex simplex) {
        this.c = simplex.c;
        this.A = simplex.A;
        this.b = simplex.b;
        this.constraints = simplex.constraints;
        this.objective = simplex.objective;
        this.t = simplex.t;
        this.n = simplex.n;
        this.m = simplex.m;
        this.lastColumn = simplex.lastColumn;
        this.originalVariables = simplex.originalVariables;
        this.slackVariables = simplex.slackVariables;
        this.artificialVariables = simplex.artificialVariables;
        this.basicVariables = simplex.basicVariables;
        this.objectiveRow = 1;
    }

    public double objectiveValue() {
        switch (this.objective) {
            case MAX: {
                return -this.t[this.objectiveRow][this.lastColumn];
            }
            case MIN: {
                return this.t[this.objectiveRow][this.lastColumn];
            }
        }
        throw new RuntimeException("Can not support objective");
    }

    private void setSolution() {
        this.basicFeasibleSolution = new double[this.n];
        for (int j = 2; j < 2 + this.n; ++j) {
            this.basicFeasibleSolution[j - 2] = this.constraintValue(j);
        }
    }

    public double[] solution() {
        return this.basicFeasibleSolution;
    }

    private void validate() {
        if (this.c.length != this.A[0].length) {
            throw new RuntimeException("Invalid number of variables");
        }
        this.n = this.c.length;
        if (this.A.length != this.b.length || this.A.length != this.constraints.length) {
            throw new RuntimeException("Invalid number of constraints");
        }
        this.m = this.b.length;
    }

    private void initVariables() {
        int size = 2 + this.n + Arrays.stream(this.constraints).mapToInt(Constraint::getVariableCount).sum() + 1;
        this.lastColumn = size - 1;
        this.t = new double[2 + this.m][size];
        this.originalVariables = new int[size];
        this.slackVariables = new int[size];
        this.artificialVariables = new int[size];
        this.basicVariables = new int[size];
        for (int j = 0; j != size; ++j) {
            this.originalVariables[j] = -1;
            this.slackVariables[j] = -1;
            this.artificialVariables[j] = -1;
            this.basicVariables[j] = -1;
        }
        int currentVariable = 2;
        int j = 0;
        while (j < this.n) {
            this.originalVariables[currentVariable++] = j++;
        }
        block7: for (int i = 0; i < this.m; ++i) {
            switch (this.constraints[i]) {
                case LOWER: {
                    this.basicVariables[currentVariable] = i;
                    this.slackVariables[currentVariable++] = i;
                    continue block7;
                }
                case EQUAL: {
                    this.basicVariables[currentVariable] = i;
                    this.artificialVariables[currentVariable++] = i;
                    continue block7;
                }
                case GREATER: {
                    this.slackVariables[currentVariable++] = i;
                    this.basicVariables[currentVariable] = i;
                    this.artificialVariables[currentVariable++] = i;
                }
            }
        }
    }

    private void runFullTableauMethod() {
        this.validate();
        this.initTableau();
        this.phase1();
        this.phase2();
        this.setSolution();
    }

    private void initTableau() {
        this.initVariables();
        this.initPhase1Goal(this.t[0]);
        this.initPhase2Goal(this.t[1]);
        this.initConstraints();
        this.initIdentity();
        this.initConstants();
        this.printTableau();
    }

    private void initPhase1Goal(double[] row) {
        row[0] = 1.0;
        row[1] = 0.0;
        for (int j = 2; j < this.lastColumn; ++j) {
            row[j] = this.artificialVariables[j] != -1 ? -1.0 : 0.0;
        }
    }

    private void initPhase2Goal(double[] row) {
        row[0] = 0.0;
        row[1] = 1.0;
        for (int j = 2; j < this.lastColumn; ++j) {
            if (this.originalVariables[j] != -1) {
                switch (this.objective) {
                    case MAX: {
                        row[j] = this.c[this.originalVariables[j]];
                        break;
                    }
                    case MIN: {
                        row[j] = -this.c[this.originalVariables[j]];
                    }
                }
                continue;
            }
            row[j] = 0.0;
        }
    }

    private void initConstraints() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.t[2 + i][2 + j] = this.A[i][j];
            }
        }
    }

    private void initIdentity() {
        for (int j = 2; j < this.lastColumn; ++j) {
            if (this.basicVariables[j] == -1) continue;
            this.t[2 + this.basicVariables[j]][j] = 1.0;
        }
    }

    private void initConstants() {
        for (int i = 0; i < this.m; ++i) {
            this.t[2 + i][this.lastColumn] = this.b[i];
        }
    }

    private void priceOut() {
        LOG.info("Price out artificial variables");
        this.printTableau();
        for (int j = 2; j < this.lastColumn; ++j) {
            if (this.artificialVariables[j] == -1) continue;
            this.sumAndReplace(this.t[0], this.t[2 + this.artificialVariables[j]]);
        }
    }

    private void phase1() {
        int c;
        LOG.info("Phase I");
        this.objectiveRow = 0;
        this.priceOut();
        this.runSimplex();
        if (this.objectiveValue() != 0.0) {
            throw new RuntimeException("Can not find a feasible basic solution");
        }
        LOG.info("Drive out artificial variables");
        while ((c = this.basicArtificialVariable()) != -1) {
            LOG.info("Leaving variable {}", (Object)c);
            this.artificialPivot(c);
        }
        this.printTableau();
    }

    private void runSimplex() {
        int c;
        LOG.info("Run Simplex");
        this.printTableau();
        while ((c = this.enteringVariable()) != -1) {
            this.pivot(c);
        }
    }

    private void runDualSimplex() {
        int row;
        LOG.info("Run Dual Simplex");
        this.printTableau();
        while ((row = this.enteringDualVariable()) != -1) {
            this.dualPivot(row);
        }
    }

    private int enteringVariable() {
        for (int j = 2; j < this.lastColumn; ++j) {
            if (this.objectiveRow != 0 && this.artificialVariables[j] != -1 || this.basicVariables[j] != -1 || !(this.t[this.objectiveRow][j] > 0.0) || !this.isValidMove(j)) continue;
            return j;
        }
        return -1;
    }

    private int enteringDualVariable() {
        for (int i = 0; i < this.m; ++i) {
            if (!(this.t[2 + i][this.lastColumn] < 0.0)) continue;
            return i;
        }
        return -1;
    }

    private void phase2() {
        LOG.info("Phase II");
        this.objectiveRow = 1;
        this.runSimplex();
    }

    private void sumAndReplace(double[] target, double[] source) {
        for (int j = 0; j < target.length; ++j) {
            int n = j;
            target[n] = target[n] + source[j];
        }
    }

    private void substractAndReplace(double[] target, double[] source) {
        for (int j = 0; j < target.length; ++j) {
            int n = j;
            target[n] = target[n] - source[j];
        }
    }

    private boolean isValidMove(int c) {
        int r = this.pivotRow(c);
        if (r == -1) {
            return false;
        }
        for (int i = 0; i < this.m; ++i) {
            if (this.t[2 + i][this.lastColumn] != 0.0 || !(-(this.t[2 + i][c] / this.t[2 + r][c]) * this.t[2 + r][this.lastColumn] < 0.0)) continue;
            return false;
        }
        return true;
    }

    private int leavingVariable(int r) {
        for (int j = 2; j < this.lastColumn; ++j) {
            if (this.basicVariables[j] == -1 || this.t[2 + r][j] != 1.0) continue;
            return j;
        }
        return -1;
    }

    private void pivot(int column) {
        int row = this.pivotRow(column);
        if (row == -1) {
            throw new RuntimeException("Can not find pivot for entering variable " + column);
        }
        int lv = this.leavingVariable(row);
        if (lv == -1) {
            throw new RuntimeException("Can not find leaving variable");
        }
        this.switchBasicVariable(column, row, lv);
    }

    private void dualPivot(int row) {
        int column = this.pivotColumn(row);
        if (column == -1) {
            LOG.info("System is infeasible");
            throw new RuntimeException(String.format("Can not find pivot column for row %d", row));
        }
        int lv = this.leavingVariable(row);
        this.switchBasicVariable(column, row, lv);
    }

    private void artificialPivot(int lv) {
        int row = this.basicVariables[lv];
        int ev = this.enteringOriginalVariable(row);
        if (ev == -1) {
            LOG.info("Can not find entering variable");
            return;
        }
        this.switchBasicVariable(ev, row, lv);
    }

    private void switchBasicVariable(int column, int row, int lv) {
        this.divideAndReplace(this.t[2 + row], this.t[2 + row][column]);
        for (int i = 0; i < 2 + this.m; ++i) {
            if (i == 2 + row) continue;
            this.diffAndReplace(this.t[i], this.t[2 + row], this.t[i][column]);
        }
        this.basicVariables[column] = row;
        this.basicVariables[lv] = -1;
        LOG.info("entering variable: {}, leaving variable {} at row {}", new Object[]{column, lv, 2 + row});
        this.printTableau();
    }

    private void printTableau() {
        Arrays.stream(this.t).forEach(this::printRow);
    }

    private void printRow(double[] row) {
        LOG.info(Arrays.stream(row).mapToObj(d -> String.format("%.2f", d)).collect(Collectors.joining(" ")));
    }

    private void divideAndReplace(double[] target, double d) {
        int j = 0;
        while (j < target.length) {
            int n = j++;
            target[n] = target[n] / d;
        }
    }

    private void diffAndReplace(double[] target, double[] source, double d) {
        for (int j = 0; j < target.length; ++j) {
            int n = j;
            target[n] = target[n] - d * source[j];
        }
    }

    private int pivotRow(int c) {
        double minRatio = Double.MAX_VALUE;
        int minRow = -1;
        for (int i = 0; i < this.m; ++i) {
            double ratio;
            if (!(this.t[2 + i][c] > 0.0) || this.t[2 + i][this.lastColumn] == 0.0 || !((ratio = this.t[2 + i][this.lastColumn] / this.t[2 + i][c]) < minRatio)) continue;
            minRatio = ratio;
            minRow = i;
        }
        return minRow;
    }

    private int pivotColumn(int row) {
        double minRatio = Double.MAX_VALUE;
        int minColumn = -1;
        for (int j = 2; j < this.lastColumn; ++j) {
            double ratio;
            if (this.artificialVariables[j] != -1 || this.basicVariables[j] != -1 || !(this.t[this.objectiveRow][j] < 0.0) || !(this.t[2 + row][j] < 0.0) || !((ratio = this.t[this.objectiveRow][j] / this.t[2 + row][j]) < minRatio)) continue;
            minRatio = ratio;
            minColumn = j;
        }
        return minColumn;
    }

    private int basicArtificialVariable() {
        for (int j = 2; j < this.lastColumn; ++j) {
            if (this.artificialVariables[j] == -1 || this.basicVariables[j] == -1) continue;
            return this.artificialVariables[j];
        }
        return -1;
    }

    private int enteringOriginalVariable(int r) {
        for (int j = 2; j < this.lastColumn; ++j) {
            if (this.originalVariables[j] == -1 || this.basicVariables[j] != -1 || this.t[2 + r][j] == 0.0) continue;
            return this.originalVariables[j];
        }
        return -1;
    }

    private double constraintValue(int j) {
        if (this.basicVariables[j] != -1) {
            return this.t[2 + this.basicVariables[j]][this.lastColumn];
        }
        return 0.0;
    }

    public void addIntegerConstraint(int i, int b, Constraint constraint) {
        this.extendTableau(i, b, constraint);
        int row = this.m - 1;
        this.substractAndReplace(this.t[2 + row], this.t[2 + this.basicVariables[2 + i]]);
        if (constraint == Constraint.GREATER) {
            this.divideAndReplace(this.t[2 + row], -1.0);
        }
        this.runDualSimplex();
        this.setSolution();
    }

    private void extendTableau(int j, int b, Constraint constraint) {
        LOG.info("Adding constraint x_{} {} {}", new Object[]{j, constraint, b});
        int size = this.t[0].length + 1;
        double[][] t2 = new double[this.t.length + 1][size];
        for (int i = 0; i < this.t.length; ++i) {
            System.arraycopy(this.t[i], 0, t2[i], 0, size - 1);
        }
        int[] originalVariables2 = new int[size];
        int[] slackVariables2 = new int[size];
        int[] artificialVariables2 = new int[size];
        int[] basicVariables2 = new int[size];
        System.arraycopy(this.originalVariables, 0, originalVariables2, 0, size - 1);
        System.arraycopy(this.slackVariables, 0, slackVariables2, 0, size - 1);
        System.arraycopy(this.artificialVariables, 0, artificialVariables2, 0, size - 1);
        System.arraycopy(this.basicVariables, 0, basicVariables2, 0, size - 1);
        for (int i = 0; i < this.t.length; ++i) {
            t2[i][this.lastColumn] = 0.0;
            t2[i][this.lastColumn + 1] = this.t[i][this.lastColumn];
        }
        ++this.lastColumn;
        ++this.m;
        this.t = t2;
        this.originalVariables = originalVariables2;
        this.slackVariables = slackVariables2;
        this.artificialVariables = artificialVariables2;
        this.basicVariables = basicVariables2;
        this.t[2 + this.m - 1][2 + j] = 1.0;
        this.t[2 + this.m - 1][this.lastColumn - 1] = constraint == Constraint.LOWER ? 1.0 : -1.0;
        this.t[2 + this.m - 1][this.lastColumn] = b;
        this.basicVariables[this.lastColumn - 1] = this.m - 1;
        this.printTableau();
    }

    public Objective objective() {
        return this.objective;
    }
}

