/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.priorityqueue;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tech.vineyard.priorityqueue.PriorityQueue;

public class Heap<T extends Comparable<T>>
implements PriorityQueue<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Heap.class);
    T[] values;
    Integer[] permutation;
    Integer[] reverse;
    int size;

    public Heap(T[] values) {
        this.values = values;
        this.size = this.values.length - 1;
        this.permutation = new Integer[this.values.length];
        this.reverse = new Integer[this.values.length];
        for (int i = 1; i < this.permutation.length; ++i) {
            this.permutation[i] = i;
            this.reverse[i] = i;
        }
        this.buildHeap();
    }

    private void buildHeap() {
        for (int i = this.size >> 1; i >= 1; --i) {
            this.trickleDown(i);
        }
    }

    private void trickleDown(int i) {
        while (i <= this.size >> 1) {
            int left = i << 1;
            int right = left + 1;
            int largest = i;
            if (left <= this.size && !this.compareTo(largest, left)) {
                largest = left;
            }
            if (right <= this.size && !this.compareTo(largest, right)) {
                largest = right;
            }
            if (largest == i) break;
            this.swap(i, largest);
            i = largest;
        }
    }

    private void swap(int i, int j) {
        this.swap(this.values, i, j);
        this.swap(this.permutation, i, j);
        this.swap(this.reverse, this.permutation[i], this.permutation[j]);
    }

    private void swap(Object[] t, int i, int j) {
        Object tmp = t[i];
        t[i] = t[j];
        t[j] = tmp;
    }

    private boolean compareTo(int i, int j) {
        return this.compareKeys(this.values[i], this.values[j]);
    }

    private boolean compareKeys(T t1, T t2) {
        return t1.compareTo(t2) <= 0;
    }

    @Override
    public void add(T t) {
        if (this.size == this.values.length - 1) {
            LOG.warn("Can not add " + t);
            return;
        }
        ++this.size;
        this.values[this.size] = t;
        this.trickleUp(this.size);
    }

    private void trickleUp(int j) {
        for (int i = j >> 1; i >= 1 && !this.compareTo(i, j); i >>= 1) {
            this.swap(i, j);
            j = i;
        }
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            LOG.warn("Heap is empty");
            return null;
        }
        return this.values[1];
    }

    @Override
    public T pop() {
        if (this.size == 0) {
            LOG.warn("Heap is empty");
            return null;
        }
        this.swap(1, this.size);
        T t = this.values[this.size];
        --this.size;
        this.trickleDown(1);
        return t;
    }

    public void decreaseKey(int i, T t) {
        if (!this.compareKeys(t, this.values[i])) {
            LOG.warn("You can only decrease the key");
            return;
        }
        this.values[i] = t;
        this.keyDecreased(i);
    }

    public void keyDecreased(int i) {
        this.trickleUp(i);
    }

    public int get(int i) {
        return this.reverse[i];
    }
}

