/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.recurrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tech.vineyard.arithmetics.ModularArithmetics;

public class MinimalPolynomial {
    private static final Logger LOG = LoggerFactory.getLogger(MinimalPolynomial.class);
    private int P;
    private List<Integer> S;
    private List<Integer> C;
    private final ModularArithmetics modularArithmetics;

    public MinimalPolynomial(int P, List<Integer> sequence) {
        this.P = P;
        this.S = sequence;
        this.modularArithmetics = new ModularArithmetics(P);
        if (sequence.size() % 2 == 1) {
            sequence.remove(sequence.size() - 1);
        }
        this.berlekampMassey();
    }

    private int berlekampMassey() {
        int L = 0;
        int m = 1;
        int N = this.S.size();
        assert (N % 2 == 0);
        this.C = new ArrayList<Integer>(Collections.nCopies(N + 1, 0));
        ArrayList<Integer> B = new ArrayList<Integer>(this.C);
        ArrayList<Integer> T = new ArrayList<Integer>();
        this.C.set(0, 1);
        B.set(0, 1);
        int b = 1;
        int degB = 0;
        for (int n = 0; n < N; ++n) {
            int i;
            int d = this.S.get(n);
            for (i = 1; i <= L; ++i) {
                d = this.sum(d, this.multiply(this.C.get(i).intValue(), this.S.get(n - i).intValue()));
            }
            if (d == 0) {
                ++m;
                continue;
            }
            if (2 * L <= n) {
                T.clear();
                for (i = 0; i <= L; ++i) {
                    T.add(this.C.get(i));
                }
            }
            int coef = this.multiply(-d, this.inverse(b));
            for (int i2 = 0; i2 <= degB; ++i2) {
                this.C.set(m + i2, this.sum(this.C.get(m + i2), this.multiply(coef, ((Integer)B.get(i2)).intValue())));
            }
            if (2 * L <= n) {
                L = n + 1 - L;
                ArrayList<Integer> tmp = B;
                B = T;
                T = tmp;
                degB = B.size() - 1;
                b = d;
                m = 1;
                continue;
            }
            ++m;
        }
        while (this.C.size() > L + 1) {
            this.C.remove(this.C.size() - 1);
        }
        assert (this.C.size() == L + 1);
        Collections.reverse(this.C);
        this.moduloIntToSigned(this.C);
        if (this.C.size() >= this.S.size() / 2 - 2) {
            LOG.warn("Sequence is not long enough" + this.S);
        }
        return L;
    }

    private void moduloIntToSigned(List<Integer> l) {
        for (int i = 0; i < l.size(); ++i) {
            if (l.get(i) <= this.P / 2) continue;
            l.set(i, l.get(i) - this.P);
        }
    }

    private int sum(int a, int b) {
        int sum = (a + b) % this.P;
        return sum < 0 ? sum + this.P : sum;
    }

    private int multiply(long a, long b) {
        return (int)(a * b % (long)this.P);
    }

    private long inverse(int a) {
        return this.modularArithmetics.inverse(a);
    }

    public List<Integer> coefficients() {
        return this.C;
    }

    public Integer get(int n) {
        if (n <= this.S.size()) {
            return this.S.get(n);
        }
        for (int i = this.S.size(); i <= n; ++i) {
            int x = 0;
            for (int j = 0; j < this.C.size() - 1; ++j) {
                x = this.sum(x, -this.multiply(this.C.get(j).intValue(), this.S.get(this.S.size() - this.C.size() + 1 + j).intValue()));
            }
            this.S.add(x);
        }
        return this.S.get(n);
    }
}

